<?php

namespace App\Http\Controllers\Backend\Covid\Export;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\FrontdeskRequest;

// use phpoffice
use PhpOffice\PhpSpreadsheet\IOFactory,
	PhpOffice\PhpSpreadsheet\Spreadsheet,
	PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class VaccineController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	protected
		$title;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;

		$this->title = __("lang.search.title");
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index(int $yy = null, int $mm = null, int $dd = null)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => (is_null($dd)) ? date('j') : $dd,
		];
		//echo '<pre>';print_r($data);die();

		// get booking_list
		$data['booking_list'] = $this->booking->getBookingList(
			$keys = [
				['yy', '=', $data['yy']],
				['mm', '=', $data['mm']],
				['dd', '=', $data['dd']],
				['is_booked', '=', 1],
			],
			$orders = [
				'dd' => 'ASC',
				'hh' => 'ASC',
				'ii' => 'ASC',
			],
			$options = []
		);
		//echo '<pre>';print_r($data['booking_list']);die();

		$callback = function() use($data) {

			$stream = fopen('php://output', 'w');

			// generate header
			fputcsv($stream, [
				'予約日',
				'予約時間',
				'接種券番号',
				'姓名カタカナ',
			]);

			foreach($data['booking_list'] as $key => $value) {
				//echo '<pre>';print_r($value);die();

				$datetime = Carbon::create(
					$value['yy'],
					$value['mm'],
					$value['dd'],
					$value['hh'],
					$value['ii'],
					0
				);
				//echo '<pre>';print_r($datetime);die();

				fputcsv($stream, [
					$datetime->toDateString(),
					$datetime->toTimeString(),
					$value['voucher_number'],
					implode(' ', [
						$value['patient_skana'],
						$value['patient_gkana'],
					]),
				]);
			}

			fclose($stream);
		};

		// 保存するファイル名
		$filename = sprintf('%s.csv', $date = Carbon::create(
			$data['yy'],
			$data['mm'],
			$data['dd'],
		)->format('Ymd'));

		$header = [
			'Content-Type' => 'application/octet-stream',
		];

		return response()->streamDownload($callback, $filename, $header);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(int $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
