<?php

namespace App\Http\Controllers\Backend\Covid\Frontdesk;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\FrontdeskRequest;


// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class ListController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	protected
		$title;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index(int $yy = null, int $mm = null, int $dd = null)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => (is_null($dd)) ? date('j') : $dd,
		];
		//echo '<pre>';print_r($data);die();

		// get booking_list
		$data['booking_list'] = $this->booking->getBookingList(
			$keys = [
				['yy', '=', $data['yy']],
				['mm', '=', $data['mm']],
				['dd', '=', $data['dd']],
				['is_booked', '=', 1],
			],
			$orders = [
				'dd' => 'ASC',
				'hh' => 'ASC',
				'ii' => 'ASC',
			],
			$options = []
		);
		//echo '<pre>';print_r($data['booking_list']);die();

		// get booking_list
		$data['booking_list_count'] = count($data['booking_list']);
		//echo '<pre>';print_r($data['booking_list_count']);die();

		// get time_list
		$data['time_list'] = Helper::getTimelineList(
			$this->master->getTimeDropdownList(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $data['mm']],
					['dd', '=', $data['dd']],
				],
				$orders = [
					'dd' => 'ASC',
				]
			)
		);
		//echo '<pre>';print_r($data['time_list']);die();

		// set nav
		$data['nav'] = 'list';

		// set form
		$data['form'] = [
			'url' => route('admin.covid.frontdesk.list.store'),
		];

		// set title
		$data['title'] = __("lang.search.title");

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.frontdesk.list.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		if(!is_null($data['booking']['patient_skana']))
			$data['booking']['patient_skana'] = mb_convert_kana($data['booking']['patient_skana'], 'C');

		if(!is_null($data['booking']['patient_gkana']))
			$data['booking']['patient_gkana'] = mb_convert_kana($data['booking']['patient_gkana'], 'C');

		// initialized
		$keys = [
			['yy', '=', $data['yy']],
			['mm', '=', $data['mm']],
			['dd', '=', $data['dd']],
			['is_booked', '=', 1],
		];

		if(!is_null($data['booking']['voucher_number'])) {

            $voucher_number = mb_convert_kana($data['booking']['voucher_number'], 'n');

			$keys = array_merge($keys, [
				['voucher_number', 'like', "%{$voucher_number}%"],
			]);
		}

		if(!is_null($data['booking']['mobile'])) {

            $mobile = mb_convert_kana($data['booking']['voucher_number'], 'n');

			$keys = array_merge($keys, [
				['mobile', 'like', "%{$mobile}%"],
			]);
		}

		if(!is_null($data['booking']['tel'])) {

            $tel = mb_convert_kana($data['booking']['tel'], 'n');

			$keys = array_merge($keys, [
				['tel', 'like', "%{$tel}%"],
			]);
		}

		if(!is_null($data['booking']['patient_skana'])) {
			$keys = array_merge($keys, [
				['patient_skana', 'like', "%{$data['booking']['patient_skana']}%"],
			]);
		}

		if(!is_null($data['booking']['patient_gkana'])) {
			$keys = array_merge($keys, [
				['patient_gkana', 'like', "%{$data['booking']['patient_gkana']}%"],
			]);
		}

		// set keys
		//echo '<pre>';print_r($keys);die();

		if($keys) {

			// get booking_list
			$data['booking_list'] = $this->booking->getBookingList(
				$keys,
				$orders = [],
				$options = []
			);
			//echo '<pre>';print_r($data['booking_list']);die();

			// get booking_list_count
			$data['booking_list_count'] = count($data['booking_list']);
		}

		// get time_list
		$data['time_list'] = Helper::getTimelineList(
			$this->master->getTimeDropdownList(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $data['mm']],
					['dd', '=', $data['dd']],
				],
				$orders = [
					'dd' => 'ASC',
				]
			)
		);
		//echo '<pre>';print_r($data['time_list']);die();

		// set nav
		$data['nav'] = 'list';

		// set form
		$data['form'] = [
			'url' => route('admin.covid.frontdesk.list.store'),
		];

		// set title
		$data['title'] = __("lang.search.title");

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.frontdesk.list.index', $data);
	}

	/**
	 * Display the specified resource.
	 */
	public function show(int $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
