<?php

namespace App\Http\Controllers\Backend\Covid\Frontdesk;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\FrontdeskRequest;


// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class SearchController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	protected
		$title;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index(int $yy = null, int $mm = null, int $dd = null)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => (is_null($dd)) ? date('j') : $dd,
		];
		//echo '<pre>';print_r($data);die();

		// set date_list
		$data['date_list'] = [
			'year_list' => Helper::getYearList(
				1900,
				date('Y')
			),
			'month_list' => Helper::getMonthList(),
			'day_list' => Helper::getDayList(),
		];
		//echo '<pre>';print_r($data['date_list']);die();

		$data['yy_list'] = Helper::getYearList(
			2023,
			date('Y')
		);

		// set nav
		$data['nav'] = 'search';

		// set form
		$data['form'] = [
			'url' => route('admin.covid.frontdesk.search.store'),
		];

		// set title
		$data['title'] = __("lang.search.title");

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.frontdesk.search.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		if(!is_null($data['booking']['patient_skana']))
			$data['booking']['patient_skana'] = mb_convert_kana($data['booking']['patient_skana'], 'C');

		if(!is_null($data['booking']['patient_gkana']))
			$data['booking']['patient_gkana'] = mb_convert_kana($data['booking']['patient_gkana'], 'C');

		// set keys
		$keys = Helper::createSearchKey($data);
		//echo '<pre>';print_r($keys);die();

		if($keys) {

			// get booking_list
			$data['booking_list'] = $this->booking->getBookingList(
				$keys,
				$orders = [],
				$options = []
			);
			//echo '<pre>';print_r($data['booking_list']);die();

			// get booking_list_count
			$data['booking_list_count'] = count($data['booking_list']);
		}

		// set date_list
		$data['date_list'] = [
			'year_list' => Helper::getYearList(
				1900,
				date('Y')
			),
			'month_list' => Helper::getMonthList(),
			'day_list' => Helper::getDayList(),
		];
		//echo '<pre>';print_r($data['date_list']);die();

		$data['yy_list'] = Helper::getYearList(
			2023,
			date('Y')
		);

		// set nav
		$data['nav'] = 'search';

		// set form
		$data['form'] = [
			'url' => route('admin.covid.frontdesk.search.store'),
		];

		// set title
		$data['title'] = $this->title;

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.frontdesk.search.index', $data);
	}

	/**
	 * Display the specified resource.
	 */
	public function show(int $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
