<?php

namespace App\Http\Controllers\Backend\Covid\Frontdesk;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\FrontdeskRequest;


// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface,
	App\Services\MathInterface;

class StatusController extends Controller
{
	protected
		$service,
		$master,
		$booking,
		$math;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking,
		MathInterface $math
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
		$this->math = $math;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index(int $yy = null, int $mm = null, int $dd = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => (is_null($dd)) ? date('j') : $dd,
		];
		//echo '<pre>';print_r($data);die();

		// set date
		$date = Carbon::create($data['yy'], $data['mm'], $data['dd'])->format('Y-m-d');
		//echo '<pre>';print_r($date);die();

		// ser link_list
		$data['link_list'] = [
			'last_week' => Helper::getDate(Carbon::parse($date)->subDay(7)->toDateString()),

			'last_day' => Helper::getDate(Carbon::parse($date)->subDay()->toDateString()),

			'next_day' => Helper::getDate(Carbon::parse($date)->addDay()->toDateString()),

			'next_week' => Helper::getDate(Carbon::parse($date)->addDay(7)->toDateString()),
		];
		//echo '<pre>';print_r($data['link_list']);die();

		// get date
		$data['date'] = $this->master->getDate(
			$keys = [
				['date', '=', $date],
			]
		);
		//echo '<pre>';print_r($data['date']);die();

		// set booking_count
		$data['booking_count'] = 0;

		if($data['date']) {

			// get time_list
			$data['time_list'] = $this->master->getTimeDropdownList(
				$keys = [
					['mtb_time.accepted_number', '>', 0],
					['mtb_time.mtb_date_id', '=', $data['date']['mtb_date_id']],
				],
				$orders = [],
				$options = []
			);
			//echo '<pre>';print_r($data['time_list']);die();

			// get booking_count
			$data['booking_count'] = $this->service->getCount(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $data['mm']],
					['dd', '=', $data['dd']],
					['is_booked', '=', 1],
					['is_cancel', '=', 0],
				],
				$table = 'dtb_booking'
			);
			//echo '<pre>';print_r($data['booking_count']);die();

			// get count_list
			$data['count_list'] = $this->math->getCountTimeList(
				$data
			);
			//echo '<pre>';print_r($data['count_list']);die();

			// get timeline_list
			$data['timeline_list'] = Helper::getTimelineList(
				$data['time_list']
			);
			//echo '<pre>';print_r($data['timeline_list']);die();
		}

		// set nav
		$data['nav'] = 'status';

		// set title
		$data['title'] = '受付管理';

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.frontdesk.status.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(FrontdeskRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		$result = \DB::transaction(function() use($data) {

			return $this->booking->storeBooking($data);
		});
		//echo '<pre>';print_r($result);die();

		// redirect
		return redirect()->route('admin.covid.frontdesk.show', [
			$data['yy'],
			$data['mm'],
			$data['dd'],
			(isset($result['booking_code'])) ? $result['booking_code'] : $result,
		]);
	}

	/**
	 * Display the specified resource.
	 */
	public function show(int $yy, int $mm, int $dd, string $booking_code = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => $yy,
			'mm' => $mm,
			'dd' => $dd,
			'booking_code' => $booking_code,
		];
		//echo '<pre>';print_r($data);die();

		if(!is_null($data['booking_code']) && $data['booking_code'] != 0) {

			// get booking
			$data['booking'] = $this->booking->getBooking(
				$keys = [
					['dtb_booking.booking_code', '=', $data['booking_code']],
				]
			);
			//echo '<pre>';print_r($data['booking']);die();
		}

		// set title
		$data['title'] = $this->title;

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// set tab
		$data['tab'] = 'frontdesk';

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.frontdesk.show', $data);
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
