<?php

namespace App\Http\Controllers\Backend\Covid;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\FrontdeskRequest;


// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class FrontdeskController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	protected
		$title;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;

		$this->title = __("lang.frontdesk.title");
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index(int $yy = null, int $mm = null, int $dd = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => (is_null($dd)) ? date('j') : $dd,
		];
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = $this->master->getDate(
			$keys = [
				['mtb_date.yy', '=', $data['yy']],
				['mtb_date.mm', '=', $data['mm']],
				['mtb_date.dd', '=', $data['dd']],
			]
		);
		//echo '<pre>';print_r($data['date']);die();

		if(is_null($data['date'])) $data['date'] = [];

		// merge date
		$data['date'] = array_merge($data['date'], [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], $data['dd'])->subDays(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], $data['dd'])->addDays(1)->toDateString()),
		]);
		//echo '<pre>';print_r($data['date']);die();

		// set form
		$data['form'] = [
			'url' => route('admin.covid.frontdesk.store'),
		];

		// set title
		$data['title'] = $this->title;

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// set tab
		$data['tab'] = 'frontdesk';

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.frontdesk.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(FrontdeskRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		$result = \DB::transaction(function() use($data) {

			return $this->booking->storeBooking($data);
		});
		//echo '<pre>';print_r($result);die();

		// redirect
		return redirect()->route('admin.covid.frontdesk.show', [
			$data['yy'],
			$data['mm'],
			$data['dd'],
			(isset($result['booking_code'])) ? $result['booking_code'] : $result,
		]);
	}

	/**
	 * Display the specified resource.
	 */
	public function show(int $yy, int $mm, int $dd, string $booking_code = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => $yy,
			'mm' => $mm,
			'dd' => $dd,
			'booking_code' => $booking_code,
		];
		//echo '<pre>';print_r($data);die();

		if(!is_null($data['booking_code']) && $data['booking_code'] != 0) {

			// get booking
			$data['booking'] = $this->booking->getBooking(
				$keys = [
					['dtb_booking.booking_code', '=', $data['booking_code']],
				]
			);
			//echo '<pre>';print_r($data['booking']);die();
		}

		// set title
		$data['title'] = $this->title;

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// set tab
		$data['tab'] = 'frontdesk';

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.frontdesk.show', $data);
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
