<?php

namespace App\Http\Controllers\Backend\Covid\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;

use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class PublishController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param  int  mtb_accepted_number_id
	 */
	public function index()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request): RedirectResponse
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		\DB::transaction(function() use($data) {
			//echo '<pre>';print_r($data);die();

			return $this->master->storePublish($data);
		});

		// redirect
		return to_route('admin.covid.master.publish.update');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update()
	{
		// initialized
		$data = [];

		// get publish
		$data['publish'] = $this->master->getPublish(
			$keys = []
		);
		//echo '<pre>';print_r($data);die();

		// set form
		$data['form'] = [
			'url' => route('admin.covid.master.publish.store'),
		];

		// set title
		$data['title'] = __("lang.master.publish.title");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.master.publish.update', $data);
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
