<?php

namespace App\Http\Controllers\Backend\Covid\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\Master\VaccineRequest;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class VaccineController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param string $table
	 * @param int $category_id
	 * @return \Illuminate\Http\Response
	 */
	public function index($mtb_vaccine_id = null)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'mtb_vaccine_id' => $mtb_vaccine_id,
		];
		//echo '<pre>';print_r($data);die();

		// get vaccine_list
		$data['vaccine_list'] = $this->master->getMasterList(
			$keys = [],
			$orders = [
				'is_disabled' => 'ASC',
				'seq' => 'ASC',
			],
			'vaccine'
		);
		//echo '<pre>';print_r($data['master_list']);die();

		// get vaccine_list_count
		$data['vaccine_list_count'] = count($data['vaccine_list']);
		//echo '<pre>';print_r($data['vaccine_list_count']);die();

		// create processing
		if(is_null($data['mtb_vaccine_id'])) {

			// get seq
			$data['seq'] = $this->master->getMax(
				$field = 'seq',
				$keys = [],
				"mtb_vaccine"
			);
			//echo '<pre>';print_r($data['seq']);die();
		}

		// update processing
		else {

			// get vaccine
			$data['vaccine'] = $this->master->getMaster(
				$keys = [
					['mtb_vaccine_id', '=', $data['mtb_vaccine_id']],
				],
				'vaccine'
			);
			//echo '<pre>';print_r($data['vaccine']);die();
		}

		// set form
		$data['form'] = [
			'url' => route('admin.covid.master.vaccine.store'),
		];

		// set title
		$data['title'] = __("lang.master.vaccine.title");

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.master.vaccine.index', $data);
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(VaccineRequest $request)
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/*
		| ------------------------------------------------------------
		| transaction
		| ------------------------------------------------------------
		 */
		\DB::transaction(function() use($data) {

			$this->master->storeVaccine($data);
		});

		// redirect
		return redirect()->route('admin.covid.master.vaccine.index');
	}

	/**
	 * Display the specified resource
	 *
	 * @param int $id
	 */
	public function show(int $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
