<?php

namespace App\Http\Controllers\Backend\Covid;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\Master\VaccineRequest;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class MasterController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param string $table
	 * @param int $category_id
	 * @return \Illuminate\Http\Response
	 */
	public function index($table, $id = null)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'table' => $table,
			'id' => $id,
		];
		//echo '<pre>';print_r($data);die();

		// create processing
		if(is_null($data['id'])) {

			// get seq
			$data['seq'] = $this->master->getMax(
				$field = 'seq',
				$keys = [],
				"mtb_{$data['table']}"
			);
			//echo '<pre>';print_r($data['seq']);die();
		}

		// update processing
		else {

			// get master
			$data['master'] = $this->master->getMaster(
				$keys = [
					["mtb_{$table}_id", '=', $data['id']],
				],
				"{$table}"
			);
			//echo '<pre>';print_r($data['master_list']);die();
		}

		// get master_list
		$data['master_list'] = $this->master->getMasterList(
			$keys = [],
			$orders = [
				'is_disabled' => 'ASC',
				'seq' => 'ASC',
			],
			"{$table}"
		);
		//echo '<pre>';print_r($data['master_list']);die();

		// get master_list_count
		$data['master_list_count'] = count($data['master_list']);
		//echo '<pre>';print_r($data['master_list_count']);die();

		// set form
		$data['form'] = [
			'url' => route('admin.covid.master.store'),
		];

		// set title
		$data['title'] = __("lang.master.{$table}.title");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.master.index', $data);
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(VaccineRequest $request)
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/*
		| ------------------------------------------------------------
		| transaction
		| ------------------------------------------------------------
		 */
		\DB::transaction(function() use($data) {

			$this->master->storeMaster($data);
		});

		// redirect
		return redirect()->route('admin.covid.master.index', [
			$data['table'],
		]);
	}

	/**
	 * Display the specified resource
	 *
	 * @param int $id
	 */
	public function show(int $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
