<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class HomeController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index($yy = null, $mm = null, $dd = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => (is_null($dd)) ? date('j') : $dd,
		];
		//echo '<pre>';print_r($data);die();

		// set date
		$data['date'] = [
			'from' => Carbon::create($data['yy'], $data['mm'], $data['dd'], 0, 0, 0)->toDateTimeString(),
			'to' => Carbon::create($data['yy'], $data['mm'], $data['dd'], 0, 0, 0)->addDay(1)->toDateTimeString(),
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], $data['dd'])->subDay(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], $data['dd'])->addDay(1)->toDateString()),
		];
		//echo '<pre>';print_r($data['date']);die();

		// get booking_list
		$data['booking_list'] = $this->booking->getBookingList(
			$keys = [
				['timestamp', '>=', $data['date']['from']],
				['timestamp', '<=', $data['date']['to']],
			],
			$orders = [
				'timestamp' => 'DESC',
			],
			$options = []
		);
		// dd($data['booking_list']);

		foreach ($data['booking_list'] as $key => $value) {

			// set age
			$data['booking_list'][$key]['age'] = Helper::getAge(Carbon::parse($value['birthday'])->format('Y-m-d'));
		}

		// get booking_list_count
		$data['booking_list_count'] = count($data['booking_list']);
		//echo '<pre>';print_r($data['booking_list_count']);die();

		// get count_list
		$data['count_list'] = Helper::getCountList(
			$data['booking_list']
		);
		//echo '<pre>';print_r($data['count_list']);die();

		// set title
		$data['title'] = 'HOME';

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.home.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
