<?php

namespace App\Http\Controllers\Backend\Maintenance;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\MaintenanceInterface;

class VoucherNumberController extends Controller
{
	protected
		$service,
		$master,
		$maintenance;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		MaintenanceInterface $maintenance
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->maintenance = $maintenance;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// initialized
		$data = [];

		// set form
		$data['form'] = [
			'url' => route('admin.maintenance.vouchernumber.store'),
		];

		// set title
		$data['title'] = '接種券（全角 → 半角）';

		//echo '<pre>';print_r($data);die();
		return view('backend.maintenance.vouchernumber.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		\DB::transaction(function() use($data) {

			$this->maintenance->updateVoucher($data);
		});

		// redirect
		return to_route('admin.maintenance.vouchernumber.complete');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function complete()
	{
		// initialized
		$data = [];

		// set title
		$data['title'] = '接種券（全角 → 半角）';

		//echo '<pre>';print_r($data);die();
		return view('backend.maintenance.vouchernumber.complete', $data);
	}
}
