<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Backend\SigninRequest;

// use components
use	Config,
	Session,
	Storage,
	Carbon\Carbon,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\StaffInterface;

class SigninController extends Controller
{
	protected
		$service,
		$master,
		$staff;

	protected
		$password;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		StaffInterface $staff
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->staff = $staff;

		$this->password = Config::get('consts.password');
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// initialized
		$data = [];

		// form
		$data['form'] = [
			'url' => route('admin.signin.store'),
		];

		// set title
		$data['title'] = __("lang.button.signin");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.signin.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * password
		 * --------------------------------------------------
		 */
		if($data['action'] == 'password') {
			//die('password');

			if($data['password'] === $this->password) {

				// set session
				Session::put('staff', [
					'is_auth' => 1,
					'is_leave' => 0,
					'is_disabled' => 0,
				]);

				// redirect
				return redirect()
					->route('admin.signin.show');
			}

			else {

				return redirect()
					->route('admin.signin.index');
			}
		}

		/**
		 * --------------------------------------------------
		 * password
		 * --------------------------------------------------
		 */
		if($data['action'] == 'staff') {
			//die('staff');

			$staff = $this->staff->getStaff(
				$keys = [
					['dtb_staff.dtb_staff_id', '=', $data['staff_id']],
				]
			);
			//echo '<pre>';print_r($staff);die();

			Session::put('staff.dtb_staff_id', $staff['dtb_staff_id']);
			Session::put('staff.staff_code', $staff['staff_code']);
			Session::put('staff.auth_key', $staff['auth_key']);
			Session::put('staff.staff_sname', $staff['staff_sname']);
			Session::put('staff.staff_gname', $staff['staff_gname']);
			Session::put('staff.staff_skana', $staff['staff_skana']);
			Session::put('staff.staff_gkana', $staff['staff_gkana']);
			Session::put('staff.is_admin', $staff['is_admin']);
			Session::put('staff.mtb_division_id', $staff['mtb_division_id']);
			Session::put('staff.division_label', $staff['division_label']);
			//echo '<pre>';print_r(Session::all());die();

			return redirect()
					->route('admin.home.index');
		}
	}

	/**
	 * Display the specified resource.
	 */
	public function show()
	{
		// initialized
		$data = [];

		// get division_list
		$data['division_list'] = $this->master->getMasterDropdownList(
			$keys = [
				['is_disabled', '=', 0],
			],
			$orders = [],
			$table = 'division'
		);
		//echo '<pre>';print_r($data['division_list']);die();

		// get staff_list
		$data['staff_list'] = $this->service->getList(
			$keys = [
				['is_leave', '=', 0],
				['is_letgo', '=', 0],
				['is_disabled', '=', 0],
			],
			$orders = [
				'mtb_division_id' => 'ASC',
				'staff_skana' => 'ASC',
			],
			$table = 'dtb_staff'
		);
		//echo '<pre>';print_r($data['staff_list']);die();

		// get staff_list_count
		$data['staff_list_count'] = count($data['staff_list']);
		//echo '<pre>';print_r($data['staff_list_count']);die();

		// form
		$data['form'] = [
			'url' => route('admin.signin.store'),
		];

		// set title
		$data['title'] = __("lang.button.signin");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.signin.show', $data);
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy()
	{
		// flushing session
		\Session::flush();

		return redirect()->route('admin.signin.index');
	}
}
