<?php

namespace App\Http\Controllers\Frontend\Covid\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

// use components
use Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class ConfirmController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get vaccine
		$vaccine = $this->service->getFirst(
			$keys = [
				['mtb_vaccine_id', '=', Session::get('booking.mtb_vaccine_id')],
			],
			$table = 'mtb_vaccine'
		);

		// get vaccine_label
		$data['vaccine_label'] = $vaccine ? $vaccine['vaccine_label'] : null;

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking.confirm.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// get progress
		$data['progress'] = Helper::getProgress(8);
		//echo '<pre>';print_r($data['progress']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.confirm.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		\DB::transaction(function () use ($data) {
			//echo '<pre>';print_r($data);die();

			$data['booking'] = $this->booking->storeBooking($data);
			//echo '<pre>';print_r($data['booking']);die();

			// send sms
			$sms = $this->booking->sendSms(
				$data['booking']
			);

			//die('ok');
		});

		// redirect
		return redirect()->route('frontend.covid.booking.confirm.complete');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function complete()
	{
		// initialized
		$data = [];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.confirm.complete', $data);
	}
}
