<?php

namespace App\Http\Controllers\Frontend\Covid\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking\DatetimeRequest;

// use components
use    Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class DatetimeController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param int yy
	 * @param int mm
	 * @param int dd
	 * @param int hh
	 * @param int ii
	 */
	public function index($yy = null, $mm = null, $dd = null, $hh = null, $ii = null)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get parameters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => $dd,
			'hh' => $hh,
			'ii' => $ii,
			'is_pm' => (is_null($hh)) ? 0 : Helper::getMeridiem($hh, $ii),
		];
		//echo '<pre>';print_r($data);die();

		// get mtb_vaccine_id
		$mtb_vaccine_id = Session::get('booking.mtb_vaccine_id');
		//echo '<pre>';print_r($mtb_vaccine_id);die();

		// get enabled_date
		$data['enabled_date'] = Carbon::today()->addDay(2);
		//echo '<pre>';print_r($data['enabled_date']->toDateString());die();

		// get min_dd
		$min_dd = ($data['enabled_date']->copy()->format('n') == $data['mm']) ? $data['enabled_date']->copy()->format('j') : 1;
		//echo '<pre>';print_r($min_dd);die();

		if(is_null($data['dd'])) {
			//die('null');

			// set keys
			$keys = (is_null($mtb_vaccine_id)) ? [] : [
				'mtb_vaccine_id' => $mtb_vaccine_id,
				//['mtb_vaccine_id', '=', $mtb_vaccine_id],
			];
			//echo '<pre>';print_r($keys);die();

			// set date
			$date = Carbon::create(
				$data['yy'],
				$data['mm'],
				$min_dd
			)->toDateString();
			//echo '<pre>';print_r($date);die();

			// append keys
			$keys = array_merge($keys, [
				'date' => $date,
				//['yy', '=', $data['yy']],
				//['mm', '=', $data['mm']],
				//['mtb_date.dd', '>=', $min_dd],
			]);
			//echo '<pre>';print_r($keys);die();

			// get min_day
			$min_day = $this->master->getMinDate(
				$keys
			);
			//$min_day = $this->service->getMin(
			//	$field = 'dd',
			//	$keys,
			//	$table = 'mtb_date'
			//);
			//echo '<pre>';print_r($min_day);die();

			$data['dd'] = (is_null($min_day)) ? 1 : $min_day;
			//echo '<pre>';print_r($data['dd']);die();
		}
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->subMonth(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->addMonth(1)->toDateString()),
			'day' => Carbon::create($data['yy'], $data['mm'], 1)->endOfMonth()->format('j'),
			'week' => Carbon::create($data['yy'], $data['mm'], 1)->startOfMonth()->format('w'),
		];
		//echo '<pre>';print_r($data['date']);die();
		
		// get enabled_month
		// mistake code
		// $enabled_month = ($data['enabled_date']->copy()->format('n') <= $data['mm']) ? $data['mm'] : null;
		$enabled_month = ($data['enabled_date']->lte(Carbon::create($data['yy'], $data['mm'], $data['dd']))) ? $data['mm'] : null;
		//echo '<pre>';print_r($enabled_month);die();
		
		// get booking_list
		$data['booking_list'] = $this->booking->getBookingCountList(
			$keys = [
				'yy' => $data['yy'],
				'mm' => $enabled_month,
				'dd' => $min_dd,
				'mtb_vaccine_id' => $mtb_vaccine_id,
			]
		);
		//echo '<pre>';print_r($data['booking_list']);die();

		// get time_list
		$data['time_list'] = Helper::getEnabledTimeList(
			$this->master->getEnabledTimeList(
				$keys = [
					'yy' => $data['yy'],
					'mm' => $enabled_month,
					'dd' => $data['dd'],
				]
			)
		);
		//echo '<pre>';print_r($data['time_list']);die();

		// set vaccine
		$data['vaccine'] = Helper::getVaccine(
			$this->master->getdate(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $enabled_month],
					['dd', '=', $data['dd']],
				],
			)
		);
		//echo '<pre>';print_r($data['vaccine']);die();

		// set is_past
		$data['is_past'] = Carbon::create($data['yy'], $data['mm'], 1)->lte(Carbon::today()->startOfMonth());
		//echo '<pre>';print_r($data['is_past']);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking.datetime.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// get progress
		$data['progress'] = Helper::getProgress(4);
		//echo '<pre>';print_r($data['progress']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.datetime.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(DatetimeRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// get date_booking
		$date_booking = Carbon::create(
			$data['booking']['yy'],
			$data['booking']['mm'],
			$data['booking']['dd']
		);
		//echo '<pre>';print_r($date_booking);die();

		// get birthday
		$birthday = Carbon::create(
			Session::get('birthday.yy'),
			Session::get('birthday.mm'),
			Session::get('birthday.dd')
		);
		//echo '<pre>';print_r($birthday);die();

		// get return as below
		if(Helper::getIsDisabledAge(
			$date_booking,
			$birthday
		)) {
			return redirect()->route('frontend.covid.booking.datetime.error')
				->withErrors(__("lang.error.disabled_age"));
		}

		/*
		if(Session::get('booking.is_staff') == 0 && Session::get('booking.is_disease') == 0) {
			//die('here');

			// get date_booking
			$date_booking = Carbon::create(
				$data['booking']['yy'],
				$data['booking']['mm'],
				$data['booking']['dd']
			);
			//echo '<pre>';print_r($date_booking);die();

			// get birthday
			$birthday = Carbon::create(
				Session::get('birthday.yy'),
				Session::get('birthday.mm'),
				Session::get('birthday.dd')
			);
			//echo '<pre>';print_r($birthday);die();

			// get date_last
			$date_last = Carbon::create(
				Session::get('date_last.yy'),
				Session::get('date_last.mm'),
				Session::get('date_last.dd')
			);
			//echo '<pre>';print_r($date_last);die();

			// get return as below
			if(Helper::getIsDisabledAge(
				$date_booking,
				$birthday
			)) {
				return redirect()->route('frontend.covid.booking.datetime.error')
					->withErrors(__("lang.error.disabled_age"));
			}

			// get return as below
			if(Helper::getIsAvailableDate(
				$date_booking,
				$date_last
			)) {
				return redirect()->route('frontend.covid.booking.datetime.error')
					->withErrors(__("lang.error.available_date"));
			}

			// get return as below
			if(Helper::getIsSpecialCase(
				$date_booking,
				$birthday,
				$data['booking']
			)) {
				return redirect()->route('frontend.covid.booking.datetime.error')
					->withErrors(__("lang.error.special_case"));
			}
		}
		*/

		// set session
		$this->booking->setSession([
			'booking' => $data['booking'],
		]);
		//echo '<pre>';print_r(Session::all());die();

		// redirect
		return redirect()->route('frontend.covid.booking.pencil.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function error()
	{
		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.datetime.error', $data);
	}
}
