<?php

namespace App\Http\Controllers\Frontend\Covid\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking\DiseaseRequest;

// use components
use    Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class DiseaseController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking.disease.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// get progress
		$data['progress'] = Helper::getProgress(2);
		//echo '<pre>';print_r($data['progress']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.disease.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	// public function store(DiseaseRequest $request)
	public function store(DiseaseRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// set session
		$this->booking->setSession([
			'booking' => $data['booking'],
		]);
		//echo '<pre>';print_r(Session::all());die();

		// redirect
		return redirect()->route('frontend.covid.booking.condition.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
