<?php

namespace App\Http\Controllers\Frontend\Covid\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking\GuestRequest;

// use components
use    Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class GuestController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// set date_list
		$data['date_list'] = [
			'year_list' => Helper::getYearList(
				1900,
				date('Y')
			),
			'month_list' => Helper::getMonthList(),
			'day_list' => Helper::getDayList(),
		];
		//echo '<pre>';print_r($data['date_list']);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking.guest.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// get progress
		$data['progress'] = Helper::getProgress(7);
		//echo '<pre>';print_r($data['progress']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.guest.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(GuestRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// set session
		$this->booking->setSession([
			'booking' => $data['booking'],
		]);
		//echo '<pre>';print_r(Session::all());die();

		// convert to hirakana to katakana
		Session::put('booking.patient_skana', Helper::convert2Kana(Session::get('booking.patient_skana')));
		Session::put('booking.patient_gkana', Helper::convert2Kana(Session::get('booking.patient_gkana')));
		Session::put('booking.mobile', Helper::sanitizeNumber(Session::get('booking.mobile')));
		//echo '<pre>';print_r(Session::all());die();

		// redirect
		return redirect()->route('frontend.covid.booking.confirm.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
