<?php

namespace App\Http\Controllers\Frontend\Covid\Booking\Mypage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use Carbon\Carbon,
    Config,
    Session,
    App\Helper;

// use services
use App\Services\ServiceInterface,
    App\Services\MasterInterface,
    App\Services\BookingInterface;

class GuestController extends Controller
{
    protected
        $service,
        $master,
        $booking;

    public function __construct(
        ServiceInterface $service,
        MasterInterface $master,
        BookingInterface $booking
    ) {
        parent::__construct();

        $this->service = $service;
        $this->master = $master;
        $this->booking = $booking;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // initialized
        $data = [];

        // set form
        $data['form'] = [
            'url' => route('frontend.covid.booking.mypage.signin.store'),
        ];

        // set title
        $data['title'] = __("lang.booking.index");

        // get lang
        $data['lang'] = $this->lang;
        //echo '<pre>';print_r($data['lang']);die();

        //echo '<pre>';print_r($data);die();
        return view('frontend.covid.booking.mypage.guest.index', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // initialized
        $data = [];

        // get request
        $data = $request->all();
        //echo '<pre>';print_r($data);die();

        // signin processing

        // redirect
        return redirect()->route('frontend.covid.booking.mypage.guest.index');
    }

    /**
     * Display the specified resource.
     */
    public function show()
    {
        // initialized
        $data = [];

        // get booking

        // set title
        $data['title'] = __("lang.booking.index");

        // get lang
        $data['lang'] = $this->lang;
        //echo '<pre>';print_r($data['lang']);die();

        // get parameters
        $data['booking'] = Session::get('booking');

        //echo '<pre>';print_r($data);die();
        return view('frontend.covid.booking.mypage.guest.show', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
