<?php

namespace App\Http\Controllers\Frontend\Covid\Booking\Mypage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use Carbon\Carbon,
    Config,
    Session,
    App\Helper;

// use services
use App\Services\ServiceInterface,
    App\Services\MasterInterface,
    App\Services\BookingInterface;

class QrController extends Controller
{
    protected
        $service,
        $master,
        $booking;

    public function __construct(
        ServiceInterface $service,
        MasterInterface $master,
        BookingInterface $booking
    ) {
        parent::__construct();

        $this->service = $service;
        $this->master = $master;
        $this->booking = $booking;
    }

    /**
     * Display a listing of the resource.
     */
    // public function index($signin_code)
    public function index($yy, $mm, $dd, $signin_code)
    {
        // initialized
        $data = [];

        // get parameters
        $data = [
            'yy' => $yy,
            'mm' => $mm,
            'dd' => $dd,
            'signin_code' => $signin_code,
        ];
        //echo '<pre>';print_r($data);die();

        // get booking
        $data['booking'] = $this->booking->getBooking(
            $keys = [
                ['dtb_booking.signin_code', '=', $data['signin_code']],
            ]
        );
        //echo '<pre>';print_r($data['booking']);die();

        // set title
        $data['title'] = __("lang.booking.index");

        // get lang
        $data['lang'] = $this->lang;
        //echo '<pre>';print_r($data['lang']);die();

        //echo '<pre>';print_r($data);die();
        return view('frontend.covid.booking.mypage.qr.index', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy()
    {
        //
    }
}
