<?php

namespace App\Http\Controllers\Frontend\Covid\Booking\Mypage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking\Mypage\SigninRequest;
// use components
use Carbon\Carbon,
    Config,
    Session,
    App\Helper;

// use services
use App\Services\ServiceInterface,
    App\Services\MasterInterface,
    App\Services\BookingInterface;

class SigninController extends Controller
{
    protected
        $service,
        $master,
        $booking;

    public function __construct(
        ServiceInterface $service,
        MasterInterface $master,
        BookingInterface $booking
    ) {
        parent::__construct();

        $this->service = $service;
        $this->master = $master;
        $this->booking = $booking;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // initialized
        $data = [];

        // set date_list
        $data['date_list'] = [
            'year_list' => Helper::getYearList(
                1900,
                date('Y')
            ),
            'month_list' => Helper::getMonthList(),
            'day_list' => Helper::getDayList(),
        ];
        //echo '<pre>';print_r($data['date_list']);die();

        // set form
        $data['form'] = [
            'url' => route('frontend.covid.booking.mypage.signin.store'),
        ];

        // set title
        $data['title'] = __("lang.booking.index");

        // get lang
        $data['lang'] = $this->lang;
        //echo '<pre>';print_r($data['lang']);die();

        //echo '<pre>';print_r($data);die();
        return view('frontend.covid.booking.mypage.signin.index', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(SigninRequest $request)
    {
        // initialized
        $data = [];

        // get request
        $data = $request->all();
        //echo '<pre>';print_r($data);die();

        // signin processing
        $birthday = Carbon::create(
            $data['birthday']['yy'],
            $data['birthday']['mm'],
            $data['birthday']['dd'],
        )->toDateString();

        // get booking
        $result = $this->booking->getBooking(
            $keys = [
                ['voucher_number', '=', $data['booking']['voucher_number']],
                ['birthday', '=', $birthday],
                ['is_booked', '=', 1],
            ]
        );

        $this->booking->setSession([
            'booking' => $result,
        ]);

        // redirect
        return redirect()->route('frontend.covid.booking.mypage.guest.show');
    }

    /**
     * Display the specified resource.
     */
    public function show($yy, $mm, $dd, $signin_code)
    {
        // initialized
        $data = [];

        // get parameters
        $data = [
            'yy' => $yy,
            'mm' => $mm,
            'dd' => $dd,
            'signin_code' => $signin_code,
        ];
        //echo '<pre>';print_r($data);die();

        // get booking
        $result = $this->booking->getBooking(
            $keys = [
                ['dtb_booking.signin_code', '=', $data['signin_code']],
                ['is_booked', '=', 1],
            ]
        );
        //echo '<pre>';print_r($data['booking']);die();

        $this->booking->setSession([
            'booking' => $result,
        ]);

        // redirect
        return redirect()->route('frontend.covid.booking.mypage.guest.show');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy()
    {
        // signout processing
        Session::flush();

        // redirect
        return redirect()->route('frontend.covid.booking.mypage.signin.index');
    }
}
