<?php

namespace App\Http\Controllers\Frontend\Covid\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class PencilController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get accepted_number
		$accepted_number = $this->service->getField(
			$field = 'accepted_number',
			$keys = [
				['mtb_date_id', '=', $this->service->getField(
					$field = 'mtb_date_id',
					$keys = [
						['yy', '=', Session::get('booking.yy')],
						['mm', '=', Session::get('booking.mm')],
						['dd', '=', Session::get('booking.dd')],
					],
					$table = 'mtb_date'
				)],
				['hh', '=', Session::get('booking.hh')],
				['ii', '=', Session::get('booking.ii')],
			],
			$table = 'mtb_time'
		);
		//echo '<pre>';print_r($accepted_number);die();

		// get booking_count
		$booking_count = $this->service->getCount(
			$keys = [
				['dtb_booking.yy', '=', Session::get('booking.yy')],
				['dtb_booking.mm', '=', Session::get('booking.mm')],
				['dtb_booking.dd', '=', Session::get('booking.dd')],
				['dtb_booking.hh', '=', Session::get('booking.hh')],
				['dtb_booking.ii', '=', Session::get('booking.ii')],
				//['dtb_booking.is_booked', '=', 1],
				['dtb_booking.is_pencil', '=', 1],
			],
			$table = 'dtb_booking'
		);
		//echo '<pre>';print_r($booking_count);die();

		if($accepted_number > $booking_count) {

			// get vaccine
			$data['vaccine'] = $this->master->getMaster(
				$keys = [
					['mtb_vaccine_id', '=', Session::get('booking.mtb_vaccine_id')],
				],
				$table = 'vaccine'
			);
			//echo '<pre>';print_r($data['vaccine']);die();

			// set form
			$data['form'] = [
				'url' => route('frontend.covid.booking.pencil.store'),
			];

			// set title
			$data['title'] = __("lang.booking.index");

			// get lang
			$data['lang'] = $this->lang;
			//echo '<pre>';print_r($data['lang']);die();

			return view('frontend.covid.booking.pencil.index', $data);
		}

		else {

			die('error');
		}
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// get accepted_number
		$accepted_number = $this->service->getField(
			$field = 'accepted_number',
			$keys = [
				['mtb_date_id', '=', $this->service->getField(
					$field = 'mtb_date_id',
					$keys = [
						['yy', '=', Session::get('booking.yy')],
						['mm', '=', Session::get('booking.mm')],
						['dd', '=', Session::get('booking.dd')],
					],
					$table = 'mtb_date'
				)],
				['hh', '=', Session::get('booking.hh')],
				['ii', '=', Session::get('booking.ii')],
			],
			$table = 'mtb_time'
		);
		//echo '<pre>';print_r($accepted_number);die();

		// get booking_count
		$booking_count = $this->service->getCount(
			$keys = [
				['dtb_booking.yy', '=', Session::get('booking.yy')],
				['dtb_booking.mm', '=', Session::get('booking.mm')],
				['dtb_booking.dd', '=', Session::get('booking.dd')],
				['dtb_booking.hh', '=', Session::get('booking.hh')],
				['dtb_booking.ii', '=', Session::get('booking.ii')],
				//['dtb_booking.is_booked', '=', 1],
				['dtb_booking.is_pencil', '=', 1],
			],
			$table = 'dtb_booking'
		);
		//echo '<pre>';print_r($booking_count);die();

		// get mtb_vaccine_id
		$mtb_vaccine_id = $this->master->getDate(
			$keys = [
				['yy', '=', Session::get('booking.yy')],
				['mm', '=', Session::get('booking.mm')],
				['dd', '=', Session::get('booking.dd')],
			],
		)['mtb_vaccine_id'];
		//echo '<pre>';print_r($data['vaccine']);die();

		// booking on
		if($accepted_number > $booking_count) {
			//die('booking on');

			// set session
			$this->booking->setSession([
				'booking.mtb_vaccine_id' => $mtb_vaccine_id
			]);
			//echo '<pre>';print_r(Session::all());die();

			// get agent
			$data['agent'] = Helper::getAgent($request);
			//echo '<pre>';print_r($data['agent']);die();

			/**
			 * --------------------------------------------------
			 * transaction
			 * --------------------------------------------------
			 */
			\DB::transaction(function() use($data) {
				//echo '<pre>';print_r($data);die();

				$this->booking->storePencil($data);
			});

			// redirect
			return redirect()->route('frontend.covid.booking.qr.index');
		}

		// booking off
		else {
			//die('booking off');
		}
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
