<?php

namespace App\Http\Controllers\Frontend\Covid\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking\PersonalRequest;

// use components
use    Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class PersonalController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// set date_list
		$data['date_list'] = [
			'year_list' => Helper::getYearList(
				1900,
				Carbon::now()->subYear(12)->format('Y'),
			),
			'month_list' => Helper::getMonthList(),
			'day_list' => Helper::getDayList(),
			'wareki_list' => Helper::getWarekiYear(),
		];
		//echo '<pre>';print_r($data['date_list']);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking.personal.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// get progress
		$data['progress'] = Helper::getProgress(1);
		//echo '<pre>';print_r($data['progress']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.personal.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	// public function store(PersonalRequest $request)
	public function store(PersonalRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// added on 2023.08.30
		// set is_staff
		$data['booking']['is_staff'] = 0;

		// set session
		$this->booking->setSession([
			'booking' => $data['booking'],
			'birthday' => $data['birthday'],
		]);
		//echo '<pre>';print_r(Session::all());die();

		// set session
		Session::put('booking.is_disease', 0);

		// redirect
		return redirect()->route('frontend.covid.booking.condition.index');

		// as staff
		//if(Session::get('booking.is_staff')) {

		//	// set session
		//	Session::put('booking.is_disease', 0);

		//	// redirect
		//	return redirect()->route('frontend.covid.booking.condition.index');
		//}

		// as not staff
		//else {

		//	// redirect
		//	return redirect()->route('frontend.covid.booking.disease.index');
		//}
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
