<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class AgreementController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// set title
		$data['title'] = __('lang.booking.index');

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// dd($data);
		return view('frontend.covid.booking2.agreement.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
