<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

// use components
use Config,
	DB,
	Session,
	Carbon\Carbon,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class ConfirmController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// dd(session()->all());
		
		if (is_null(session()->get('form'))) {
			return redirect()->route('frontend.covid.booking2.home.index');
		}

		// initialized
		$data = [];

		// get vaccine
		$vaccine = $this->service->getFirst(
			$keys = [
				['mtb_vaccine_id', '=', session()->get('booking.mtb_vaccine_id')],
			],
			$table = 'mtb_vaccine'
		);
		// dd($vaccine);

		// get vaccine_label
		$data['vaccine_label'] = $vaccine ? $vaccine['vaccine_label'] : null;
		// dd($data['vaccine_label']);

		// get pref_label
		$data['pref_label'] = $this->service->getField(
			$field = 'pref_label',
			$keys = [
				['mtb_pref_id', '=', session()->get('booking.mtb_pref_id')],
			],
			$table = 'mtb_pref'
		);
		// dd($data['pref_label']);

		if (session()->get('form') !== null) {

			// get form_list
			$data['form_list'] = $this->master->getMasterList(
				$keys = [],
				$orders = [],
				$table = 'form'
			);
			// dd($data['form_list']);
		}

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking2.confirm.store'),
		];

		// set title
		$data['title'] = __('lang.booking.index');

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// get progress
		$data['progress'] = Helper::getProgress(4);
		// dd($data['progress']);

		// dd($data);
		return view('frontend.covid.booking2.confirm.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		// dd(session()->all());

		// if (session()->get('booking.form') === null) return redirect()->route('frontend.covid.booking2.home.index');

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		DB::transaction(function () use ($data) {
			// dd($data);

			$data['booking'] = $this->booking->storeBooking2($data);
			// dd($data['booking']);

			// dd(session()->all());
			if (session()->get('booking.is_form')) {

				$this->booking->storeForm($data);
				// dd('ok');
			}

			// send sms
			$sms = $this->booking->sendSms2(
				$data['booking']
			);

			// dd('ok');
		});

		// redirect
		return redirect()->route('frontend.covid.booking2.confirm.complete');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function complete()
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get booking
		$data['booking'] = $this->booking->getBooking(
			$keys = [
				['booking_code', '=', session()->get('booking.booking_code')],
			]
		);
		// dd($data['booking']);

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// forget session
		session()->forget('form');

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking2.confirm.complete', $data);
	}
}
