<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking\DatetimeRequest;

// use components
use    Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class DatetimeController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param int yy
	 * @param int mm
	 * @param int dd
	 * @param int hh
	 * @param int ii
	 */
	public function index($yy = null, $mm = null, $dd = null, $hh = null, $ii = null)
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get parameters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => $dd,
			'hh' => $hh,
			'ii' => $ii,
			'is_pm' => (is_null($hh)) ? 0 : Helper::getMeridiem($hh, $ii),
		];
		// dd($data);

		// get mtb_vaccine_id
		$mtb_vaccine_id = null;
		// dd($mtb_vaccine_id);

		// get enabled_date
		$data['enabled_date'] = Carbon::today()->addDay(config()->get('consts.enabled_date'));
		// $data['enabled_date'] = Carbon::today()->addDay(2);
		// dd($data['enabled_date']);

		// get min_dd
		$min_dd = ($data['enabled_date']->copy()->format('n') == $data['mm']) ? $data['enabled_date']->copy()->format('j') : 1;
		// dd($min_dd);

		if(is_null($data['dd'])) {
			// dd('null');

			// set keys
			$keys = (is_null($mtb_vaccine_id)) ? [] : [
				'mtb_vaccine_id' => $mtb_vaccine_id,
			];
			// dd($keys);

			// set date
			$date = Carbon::create(
				$data['yy'],
				$data['mm'],
				$min_dd
			)->toDateString();
			// dd($date);

			// append keys
			$keys = array_merge($keys, [
				'date' => $date,
			]);
			// dd($keys);

			// get min_day
			$min_day = $this->master->getMinDate(
				$keys
			);
			// dd($min_day);

			$data['dd'] = (is_null($min_day)) ? 1 : $min_day;
			// dd($data['dd']);
		}
		// dd($data);

		// get date
		$data['date'] = [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->subMonth(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->addMonth(1)->toDateString()),
			'day' => Carbon::create($data['yy'], $data['mm'], 1)->endOfMonth()->format('j'),
			'week' => Carbon::create($data['yy'], $data['mm'], 1)->startOfMonth()->format('w'),
		];
		// dd($data['date']);
		
		// get enabled_month
		$enabled_month = ($data['enabled_date']->lte(Carbon::create($data['yy'], $data['mm'], $data['dd']))) ? $data['mm'] : null;
		// dd($enabled_month);
		
		// get booking_list
		$data['booking_list'] = $this->booking->getBookingCountList(
			$keys = [
				'yy' => $data['yy'],
				'mm' => $enabled_month,
				'dd' => $min_dd,
				'mtb_vaccine_id' => $mtb_vaccine_id,
			]
		);
		// dd($data['booking_list']);

		// get time_list
		$data['time_list'] = Helper::getEnabledTimeList(
			$this->master->getEnabledTimeList(
				$keys = [
					'yy' => $data['yy'],
					'mm' => $enabled_month,
					'dd' => $data['dd'],
				]
			)
		);
		// dd($data['time_list']);

		// set vaccine
		$data['vaccine'] = Helper::getVaccine(
			$this->master->getdate(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $enabled_month],
					['dd', '=', $data['dd']],
				],
			)
		);
		// dd($data['vaccine']);

		// set is_past
		$data['is_past'] = Carbon::create($data['yy'], $data['mm'], 1)->lte(Carbon::today()->startOfMonth());
		// dd($data['is_past']);

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking2.datetime.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// get progress
		$data['progress'] = Helper::getProgress(1);
		// dd($data['progress']);

		// dd($data);
		return view('frontend.covid.booking2.datetime.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(DatetimeRequest $request)
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		// get date_booking
		$date_booking = Carbon::create(
			$data['booking']['yy'],
			$data['booking']['mm'],
			$data['booking']['dd']
		);
		// dd($date_booking);

		// set session
		$this->booking->setSession([
			'booking' => $data['booking'],
		]);
		// dd(session()->all());

		// redirect
		return redirect()->route('frontend.covid.booking2.subconfirm.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function error()
	{
		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.datetime.error', $data);
	}
}
