<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

// use requests
use App\Http\Requests\Frontend\Covid\Booking2\VaccineFormRequest;

// use components
use Config,
	DB,
	Session,
	Carbon\Carbon,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class FormController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// call helper
		Helper::setIsForm($data);
		// dd(session()->all());

		// get form_list
		$data['form_list'] = $this->master->getMasterList(
			$keys = [],
			$orders = [],
			$table = 'form'
		);
		// dd($data['form_list']);

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking2.form.store'),
			'class' => 'h-adr',
		];

		// set title
		$data['title'] = __('lang.booking.index');

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// get progress
		$data['progress'] = Helper::getProgress(3);
		// dd($data['progress']);

		// dd($data);
		return view('frontend.covid.booking2.form.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(VaccineFormRequest $request)
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		// set session
		if (isset($data['form'])) {

			$this->booking->setSession([
				'form' => $data['form'],
			]);
			// dd(session()->all());

			if (!isset($data['form'][6])) Session::put('form.6.value', 1);
		}

		// redirect
		return redirect()->route('frontend.covid.booking2.confirm.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
