<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

// use requests
use App\Http\Requests\Frontend\Covid\Booking2\GuestRequest;

// use components
use Config,
	DB,
	Session,
	Carbon\Carbon,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class GuestController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// set date_list
		$data['date_list'] = [
			'year_list' => Helper::getYearList(
				1900,
				date('Y')
			),
			'month_list' => Helper::getMonthList(),
			'day_list' => Helper::getDayList(),
		];
		// dd($data['date_list']);

		// get pref_list
		$data['pref_list'] = $this->master->getMasterDropdownList(
			$keys = [],
			$orders = [],
			$table = 'pref'
		);
		// dd($data['pref_list']);

		// set booking_date
		$booking_date = Carbon::create(
			session()->get('booking.yy'),
			session()->get('booking.mm'),
			session()->get('booking.dd')
		);

		// set due_date
		$due_date = Carbon::create(
			2025,
			2,
			1
		);

		// set due
		$data['due'] = $booking_date->gt($due_date) ? 1 : 0;
		// dd($data['due']);

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking2.guest.store'),
			'class' => 'h-adr',
		];

		// set title
		$data['title'] = __('lang.booking.index');

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// get progress
		$data['progress'] = Helper::getProgress(2);
		// dd($data['progress']);

		// dd($data);
		return view('frontend.covid.booking2.guest.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(GuestRequest $request)
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		// set session
		$this->booking->setSession([
			'booking' => $data['booking'],
			'birthday' => $data['birthday'],
		]);
		// dd(session()->all());

		// convert to hirakana to katakana
		// session()->put('booking.patient_skana', Helper::convert2Kana(session()->get('booking.patient_skana')));
		// session()->put('booking.patient_gkana', Helper::convert2Kana(session()->get('booking.patient_gkana')));
		session()->put('booking.mobile', Helper::sanitizeNumber(session()->get('booking.mobile')));
		session()->put('booking.age', Helper::getAge(Carbon::create($data['birthday']['yy'], $data['birthday']['mm'], $data['birthday']['dd'])->format('Y-m-d')));
		// dd(session()->all());

		// redirect
		return redirect()->route('frontend.covid.booking2.form.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
