<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class HomeController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		session()->flush();
		// dd(session()->all());

		// initialized
		$data = [];

		// get today
		// $data['today'] = Carbon::today();
		//echo '<pre>';print_r($data);die();

		// get publish
		// $data['publish'] = $this->master->getPublish(
		// 	$keys = []
		// );
		// dd($data['publish']);

		// create timestamp
		$data['timestamp_publish'] = Carbon::create(2024, 9, 25, 12, 0, 0)->timestamp;
		// dd($data['timestamp_publish']);

		$data['timestamp_now'] = Carbon::now()->timestamp;
		// dd($data['timestamp_now']);

		// set title
		$data['title'] = __('lang.booking.index');

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// dd($data);
		return view('frontend.covid.booking2.home.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
