<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2\Mypage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking\DatetimeRequest;

// use components
use Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class DatetimeController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		return \DB::transaction(function() use($data) {
			// dd($data);

			$return = $this->service->updateRow(
				$keys = [
					['dtb_booking_id', '=', session()->get('booking.dtb_booking_id')],
				],
				$values = [
					'yy' => $data['booking']['yy'],
					'mm' => $data['booking']['mm'],
					'dd' => $data['booking']['dd'],
					'hh' => $data['booking']['hh'],
					'ii' => $data['booking']['ii'],
				],
				$table = 'dtb_booking'
			);
			// dd($return);

			// send sms
			$sms = $this->booking->sendSms2(
				$data = Session::get('booking'),
				$is_changed = true,
			);
			// dd('ok');

			// redirect
			return redirect()->route('frontend.covid.booking2.mypage.datetime.complete');
		});
	}

	/**
	 * Display the specified resource.
	 */
	public function show()
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update($yy = null, $mm = null, $dd = null, $hh = null, $ii = null)
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get parameters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => $dd,
			'hh' => $hh,
			'ii' => $ii,
			'is_pm' => (is_null($hh)) ? 0 : Helper::getMeridiem($hh, $ii),
		];
		// dd($data);

		// get mtb_vaccine_id
		$mtb_vaccine_id = Session::get('booking.mtb_vaccine_id');
		// dd(session()->all());

		// get enabled_date
		$data['enabled_date'] = Carbon::today()->addDay(config()->get('consts.enabled_date'));
		// dd($data['enabled_date']);

		// get min_dd
		$min_dd = ($data['enabled_date']->copy()->format('n') == $data['mm']) ? $data['enabled_date']->copy()->format('j') : 1;
		// dd($min_dd);

		// get dd
		if(is_null($data['dd'])) {

			// set keys
			$keys = (is_null($mtb_vaccine_id)) ? [] : [
				'mtb_vaccine_id' => $mtb_vaccine_id,
				//['mtb_vaccine_id', '=', $mtb_vaccine_id],
			];
			//echo '<pre>';print_r($keys);die();

			// set date
			$date = Carbon::create(
				$data['yy'],
				$data['mm'],
				$min_dd
			)->toDateString();
			//echo '<pre>';print_r($date);die();

			// append keys
			$keys = array_merge($keys, [
				'date' => $date,
				//['yy', '=', $data['yy']],
				//['mm', '=', $data['mm']],
				//['mtb_date.dd', '>=', $min_dd],
			]);
			//echo '<pre>';print_r($keys);die();

			// get min_day
			$min_day = $this->master->getMinDate(
				$keys
			);
			//$min_day = $this->service->getMin(
			//	$field = 'dd',
			//	$keys,
			//	$table = 'mtb_date'
			//);
			//echo '<pre>';print_r($min_day);die();

			$data['dd'] = (is_null($min_day)) ? 1 : $min_day;
		}
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->subMonth(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->addMonth(1)->toDateString()),
			'day' => Carbon::create($data['yy'], $data['mm'], 1)->endOfMonth()->format('j'),
			'week' => Carbon::create($data['yy'], $data['mm'], 1)->startOfMonth()->format('w'),
		];
		//echo '<pre>';print_r($data['date']);die();

		// get enabled_month
		$enabled_month = ($data['enabled_date']->copy()->format('n') <= $data['mm']) ? $data['mm'] : null;

		// get booking_list
		$data['booking_list'] = $this->booking->getBookingCountList(
			$keys = [
				'yy' => $data['yy'],
				'mm' => $enabled_month,
				'dd' => $min_dd,
				'mtb_vaccine_id' => $mtb_vaccine_id,
			]
		);
		//echo '<pre>';print_r($data['booking_list']);die();

		// get time_list
		$data['time_list'] = Helper::getEnabledTimeList(
			$this->master->getEnabledTimeList(
				$keys = [
					'yy' => $data['yy'],
					'mm' => $enabled_month,
					'dd' => $data['dd'],
				]
			)
		);
		//echo '<pre>';print_r($data['time_list']);die();

		// get enabled_month
		$enabled_month = ($data['enabled_date']->copy()->format('n') <= $data['mm']) ? $data['mm'] : null;

		// get booking_list
		$data['booking_list'] = $this->booking->getBookingCountList(
			$keys = [
				'yy' => $data['yy'],
				'mm' => $enabled_month,
				'dd' => $min_dd,
				'mtb_vaccine_id' => $mtb_vaccine_id,
			]
		);
		//echo '<pre>';print_r($data['booking_list']);die();

		// get time_list
		$data['time_list'] = Helper::getEnabledTimeList(
			$this->master->getEnabledTimeList(
				$keys = [
					'yy' => $data['yy'],
					'mm' => $enabled_month,
					'dd' => $data['dd'],
				]
			)
		);
		//echo '<pre>';print_r($data['time_list']);die();

		// set vaccine
		$data['vaccine'] = Helper::getVaccine(
			$this->master->getdate(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $enabled_month],
					['dd', '=', $data['dd']],
				],
			)
		);
		//echo '<pre>';print_r($data['vaccine']);die();

		// set is_past
		$data['is_past'] = Carbon::create($data['yy'], $data['mm'], 1)->lte(Carbon::today()->startOfMonth());
		//echo '<pre>';print_r($data['is_past']);die();

		// get booking
		$data['booking'] = Session::get('booking');
		//echo '<pre>';print_r($data);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking2.mypage.datetime.confirm'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		return view('frontend.covid.booking2.mypage.datetime.update', $data);
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy()
	{
		// initialized
		$data = [];

		// get booking
		$data['booking'] = Session::get('booking');
		//echo '<pre>';print_r($data);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking2.mypage.booking.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		return view('frontend.covid.booking2.mypage.booking.destroy', $data);

		///**
		// * --------------------------------------------------
		// * transaction
		// * --------------------------------------------------
		// */
		//\DB::transaction(function () {
		//	//echo '<pre>';print_r($data);die();

		//	$booking_code = Session::get('booking.booking_code');

		//	$this->booking->deleteRow(
		//		$keys = [
		//			['booking_code', '=', $booking_code],
		//		],
		//		$table = 'dtb_booking'
		//	);

		//	// // send sms
		//	$canceled_booking = Session::get('booking');

		//	$sms = $this->booking->sendSmsCancel($canceled_booking);

		//	//die('ok');
		//});

		//// redirect
		//return redirect()->route('frontend.covid.booking.home.index');
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function confirm(DatetimeRequest $request)
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking2.mypage.datetime.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// dd($data);
		return view('frontend.covid.booking2.mypage.datetime.confirm', $data);
	}

	/**
	 * Display the specified resource.
	 */
	public function complete()
	{
		// initialized
		$data = [];

		// get booking
		$booking = $this->booking->getBooking(
			$keys = [
				['dtb_booking_id', '=', session()->get('booking.dtb_booking_id')],
			]
		);
		// dd($booking);

		// set session
		$this->booking->setSession([
			'booking' => $booking,
		]);
		// dd(session()->all());

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// dd($data);
		return view('frontend.covid.booking2.mypage.datetime.complete', $data);
	}
}
