<?php

namespace App\Http\Controllers\Frontend\Covid\Booking\Mypage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking\DatetimeRequest;

// use components
use Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class EditController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// initialized
		$data = [];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// get booking
		$data['booking'] = Session::get('booking');

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.mypage.edit.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(DatetimeRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// set session for storeBooking
		$this->booking->setSession($data);
		//echo '<pre>';print_r(Session::all());die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		\DB::transaction(function() use($data) {
			//echo '<pre>';print_r($data);die();

			$this->service->updateRow(
				$keys = [
					['dtb_booking_id', '=', Session::get('booking.dtb_booking_id')],
				],
				$values = [
					'yy' => $data['booking']['yy'],
					'mm' => $data['booking']['mm'],
					'dd' => $data['booking']['dd'],
					'hh' => $data['booking']['hh'],
					'ii' => $data['booking']['ii'],
					'mtb_vaccine_id' => $data['booking']['mtb_vaccine_id'],
				],
				$table = 'dtb_booking'
			);
			//echo '<pre>';print_r('store');die();

			// send sms
			$sms = $this->booking->sendSms(
				$data = Session::get('booking'),
				$is_changed = true,
			);
			//echo '<pre>';print_r(Session::get('booking'));die();
		});

		// redirect
		return redirect()->route('frontend.covid.booking.mypage.edit.complete');
	}

	/**
	 * Display the specified resource.
	 */
	public function show()
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update($yy = null, $mm = null, $dd = null, $hh = null, $ii = null)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => $dd,
			'hh' => $hh,
			'ii' => $ii,
			'is_pm' => (is_null($hh)) ? 0 : Helper::getMeridiem($hh, $ii),
		];
		//echo '<pre>';print_r($data);die();

		// get mtb_vaccine_id
		$mtb_vaccine_id = Session::get('booking.mtb_vaccine_id');

		// get enabled_date
		$data['enabled_date'] = Carbon::today()->addDay(2);
		//echo '<pre>';print_r($data['enabled_date']->toDateString());die();

		// get min_dd
		$min_dd = ($data['enabled_date']->copy()->format('n') == $data['mm']) ? $data['enabled_date']->copy()->format('j') : 1;
		//echo '<pre>';print_r($min_dd);die();

		// get dd
		if(is_null($data['dd'])) {

			// set keys
			$keys = (is_null($mtb_vaccine_id)) ? [] : [
				'mtb_vaccine_id' => $mtb_vaccine_id,
				//['mtb_vaccine_id', '=', $mtb_vaccine_id],
			];
			//echo '<pre>';print_r($keys);die();

			// set date
			$date = Carbon::create(
				$data['yy'],
				$data['mm'],
				$min_dd
			)->toDateString();
			//echo '<pre>';print_r($date);die();

			// append keys
			$keys = array_merge($keys, [
				'date' => $date,
				//['yy', '=', $data['yy']],
				//['mm', '=', $data['mm']],
				//['mtb_date.dd', '>=', $min_dd],
			]);
			//echo '<pre>';print_r($keys);die();

			// get min_day
			$min_day = $this->master->getMinDate(
				$keys
			);
			//$min_day = $this->service->getMin(
			//	$field = 'dd',
			//	$keys,
			//	$table = 'mtb_date'
			//);
			//echo '<pre>';print_r($min_day);die();

			$data['dd'] = (is_null($min_day)) ? 1 : $min_day;
		}
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->subMonth(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->addMonth(1)->toDateString()),
			'day' => Carbon::create($data['yy'], $data['mm'], 1)->endOfMonth()->format('j'),
			'week' => Carbon::create($data['yy'], $data['mm'], 1)->startOfMonth()->format('w'),
		];
		//echo '<pre>';print_r($data['date']);die();

		// get enabled_month
		$enabled_month = ($data['enabled_date']->copy()->format('n') <= $data['mm']) ? $data['mm'] : null;

		// get booking_list
		$data['booking_list'] = $this->booking->getBookingCountList(
			$keys = [
				'yy' => $data['yy'],
				'mm' => $enabled_month,
				'dd' => $min_dd,
				'mtb_vaccine_id' => $mtb_vaccine_id,
			]
		);
		//echo '<pre>';print_r($data['booking_list']);die();

		// get time_list
		$data['time_list'] = Helper::getEnabledTimeList(
			$this->master->getEnabledTimeList(
				$keys = [
					'yy' => $data['yy'],
					'mm' => $enabled_month,
					'dd' => $data['dd'],
				]
			)
		);
		//echo '<pre>';print_r($data['time_list']);die();

		// get enabled_month
		$enabled_month = ($data['enabled_date']->copy()->format('n') <= $data['mm']) ? $data['mm'] : null;

		// get booking_list
		$data['booking_list'] = $this->booking->getBookingCountList(
			$keys = [
				'yy' => $data['yy'],
				'mm' => $enabled_month,
				'dd' => $min_dd,
				'mtb_vaccine_id' => $mtb_vaccine_id,
			]
		);
		//echo '<pre>';print_r($data['booking_list']);die();

		// get time_list
		$data['time_list'] = Helper::getEnabledTimeList(
			$this->master->getEnabledTimeList(
				$keys = [
					'yy' => $data['yy'],
					'mm' => $enabled_month,
					'dd' => $data['dd'],
				]
			)
		);
		//echo '<pre>';print_r($data['time_list']);die();

		// set vaccine
		$data['vaccine'] = Helper::getVaccine(
			$this->master->getdate(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $enabled_month],
					['dd', '=', $data['dd']],
				],
			)
		);
		//echo '<pre>';print_r($data['vaccine']);die();

		// set is_past
		$data['is_past'] = Carbon::create($data['yy'], $data['mm'], 1)->lte(Carbon::today()->startOfMonth());
		//echo '<pre>';print_r($data['is_past']);die();

		// get booking
		$data['booking'] = Session::get('booking');
		//echo '<pre>';print_r($data);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking.mypage.edit.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		return view('frontend.covid.booking.mypage.edit.update', $data);
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy()
	{
		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		\DB::transaction(function () {
			//echo '<pre>';print_r($data);die();

			$booking_code = Session::get('booking.booking_code');

			$this->booking->deleteRow(
				$keys = [
					['booking_code', '=', $booking_code],
				],
				$table = 'dtb_booking'
			);

			// // send sms
			$canceled_booking = Session::get('booking');

			$sms = $this->booking->sendSmsCancel($canceled_booking);

			//die('ok');
		});

		// redirect
		return redirect()->route('frontend.covid.booking.home.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function complete()
	{
		// initialized
		$data = [];

		// signin processing

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// get booking
		$data['booking'] = Session::get('booking');

		// set vaccine
		$data['vaccine'] = Helper::getVaccine(
			$this->master->getdate(
				$keys = [
					['yy', '=', $data['booking']['yy']],
					['mm', '=', $data['booking']['mm']],
					['dd', '=', $data['booking']['dd']],
				],
			)
		);
		//echo '<pre>';print_r($data['vaccine']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.mypage.edit.complete', $data);
	}

	/**
	 * Display the error message.
	 */
	public function error()
	{
		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.mypage.edit.error', $data);
	}
}
