<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2\Mypage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class GuestController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// initialized
		$data = [];

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking.mypage.signin.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking2.mypage.guest.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// signin processing

		// redirect
		return redirect()->route('frontend.covid.booking.mypage.guest.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function show()
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get booking

		// set title
		$data['title'] = __('lang.booking.index');

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// get parameters
		$data['booking'] = Session::get('booking');
		// dd($data['booking']);

		if ($data['booking']['is_form']) {

			// get form_list
			$data['form_list'] = $this->booking->getFormList(
				$keys = [
					['dtb_form.dtb_booking_id', '=', $data['booking']['dtb_booking_id']],
				],
				$orders = [
					'mtb_form.seq' => 'ASC',
				],
				$table = 'dtb_form'
			);
			// dd($data['form_list']);
		}

		// dd($data);
		return view('frontend.covid.booking2.mypage.guest.show', $data);
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
