<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2\Mypage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Booking2\Mypage\SigninRequest;

// use components
use Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class SigninController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// initialized
		$data = [];

		// set date_list
		$data['date_list'] = [
			'year_list' => Helper::getYearList(
				1900,
				date('Y')
			),
			'month_list' => Helper::getMonthList(),
			'day_list' => Helper::getDayList(),
		];
		// dd($data['date_list']);

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking2.mypage.signin.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		// dd($data['lang']);

		// dd($data);
		return view('frontend.covid.booking2.mypage.signin.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(SigninRequest $request)
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		// signin processing
		$birthday = Carbon::create(
			$data['birthday']['yy'],
			$data['birthday']['mm'],
			$data['birthday']['dd'],
		)->toDateString();

		// get booking
		$result = $this->booking->getBooking(
			$keys = [
				['birthday', '=', $birthday],
				['mobile', '=', $data['mobile']],
				['is_booked', '=', 1],
				['is_web', '=', 1],
			]
		);
		// dd($result);

		// set session
		$this->booking->setSession([
			'booking' => $result,
		]);
		// dd(session()->all());

		// redirect
		return redirect()->route('frontend.covid.booking2.mypage.guest.show');
	}

	/**
	 * Display the specified resource.
	 */
	public function show($yy, $mm, $dd, $signin_code)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'yy' => $yy,
			'mm' => $mm,
			'dd' => $dd,
			'signin_code' => $signin_code,
		];
		//echo '<pre>';print_r($data);die();

		// get booking
		$result = $this->booking->getBooking(
			$keys = [
				['dtb_booking.signin_code', '=', $data['signin_code']],
				['is_booked', '=', 1],
			]
		);
		//echo '<pre>';print_r($data['booking']);die();

		$this->booking->setSession([
			'booking' => $result,
		]);

		// redirect
		return redirect()->route('frontend.covid.booking2.mypage.guest.show');
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy()
	{
		// signout processing
		Session::flush();

		// redirect
		return redirect()->route('frontend.covid.booking.mypage.signin.index');
	}
}
