<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2\Mypage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
// use App\Http\Requests\Frontend\Covid\Booking\VaccineRequest;

// use components
use    Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class VaccineController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get vaccine_list
		$data['vaccine_list'] = $this->master->getMasterList(
			$keys = [
				['is_show', '=', 1],
				['is_disabled', '=', 0],
			],
			$orders = [
				'seq' => 'ASC',
			],
			$table = 'vaccine'
		);
		//echo '<pre>';print_r($data['vaccine_list']);die();

		// get vaccine_list_count
		$data['vaccine_list_count'] = count($data['vaccine_list']);
		//echo '<pre>';print_r($data['vaccine_list_count']);die();

		// get booking
		$data['booking'] = Session::get('booking');
		//echo '<pre>';print_r($data['booking']);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.booking.mypage.vaccine.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.mypage.vaccine.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	// public function store(DiseaseRequest $request)
	public function store(Request $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// set session
		$this->booking->setSession([
			'mtb_vaccine_id' => $data['booking']['mtb_vaccine_id'],
		]);
		//echo '<pre>';print_r(Session::all());die();

		// redirect
		return redirect()->route('frontend.covid.booking.mypage.booking.update');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
