<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

// use components
use Config,
	DB,
	Session,
	Storage,
	Carbon\Carbon,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface,
	App\Services\FileInterface;

class PdfController extends Controller
{
	protected
		$service,
		$master,
		$booking,
		$file;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking,
		FileInterface $file
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
		$this->file = $file;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// 
	}

	/**
	 * Show the form for creating a new resource.
	 */
	public function create($signin_code)
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get parameters
		$data = [
			'signin_code' => $signin_code,
		];
		// dd($data);

		// get booking
		$data['booking'] = $this->booking->getBooking(
			$keys = [
				['dtb_booking.signin_code', '=', $data['signin_code']],
			]
		);
		// dd($data['booking']);

		if (is_null($data['booking'])) {

			return view('frontend.covid.booking2.error', $data);
		}

		// get file_dir
		$file_dir = implode('/', [
			'pdf',
			$data['booking']['yy'],
			Carbon::create($data['booking']['yy'], $data['booking']['mm'], $data['booking']['dd'])->format('md'),
		]);
		// dd($file_dir);

		// get file_name
		$file_name = implode('.', [
			$data['booking']['signin_code'],
			'pdf',
		]);
		// dd($file_name);

		// get storage_path
		$file_path = storage_path(implode('/', [
			'app/public',
			$file_dir,
			$file_name,
		]));
		// dd($file_path);

		$data['booking']['patient_name'] = implode('　', [
			$data['booking']['patient_sname'],
			$data['booking']['patient_gname'],
		]);

		$data['booking']['patient_kana'] = implode('　', [
			$data['booking']['patient_skana'],
			$data['booking']['patient_gkana'],
		]);

		$data['booking']['wareki'] = Helper::convertWareki(Carbon::parse($data['booking']['birthday'])->year);

		$data['booking']['age'] = Helper::getAge($data['booking']['birthday']);

		// if (strlen($data['booking']['mobile']) == 11) {

		// 	$data['booking']['mobile'] = [
		// 		substr($data['booking']['mobile'], 0, 3),
		// 		substr($data['booking']['mobile'], 3, 4),
		// 		substr($data['booking']['mobile'], 7, 4),
		// 	];
		// }
		// else {

		// 	$data['booking']['mobile'] = [
		// 		substr($data['booking']['mobile'], 0, 2),
		// 		substr($data['booking']['mobile'], 2, 4),
		// 		substr($data['booking']['mobile'], 6),
		// 	];
		// }

		// get form_list
		$data['form_list'] = $this->service->getList(
			$keys = [
				['dtb_booking_id', '=', $data['booking']['dtb_booking_id']],
			],
			$orders = [
				'mtb_form_id' => 'ASC',
			],
			$table = 'dtb_form'
		);
		// dd($data['form_list']);
		
		// checking booking
		// dd($data['booking']);

		$this->file->CreateFormPDF($data);		

		// set url
		$url = url(implode('/', [
			'storage',
			$file_dir,
			$file_name,
		]));
		// dd($url);

		return redirect()->to($url);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
