<?php

namespace App\Http\Controllers\Frontend\Covid\Booking2;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use Config,
	DB,
	Session,
	Carbon\Carbon,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class SubConfirmController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// dd(session()->all());

		// initialized
		$data = [];

		// get accepted_number
		$accepted_number = $this->service->getField(
			$field = 'accepted_number',
			$keys = [
				['mtb_date_id', '=', $this->service->getField(
					$field = 'mtb_date_id',
					$keys = [
						['yy', '=', Session::get('booking.yy')],
						['mm', '=', Session::get('booking.mm')],
						['dd', '=', Session::get('booking.dd')],
					],
					$table = 'mtb_date'
				)],
				['hh', '=', Session::get('booking.hh')],
				['ii', '=', Session::get('booking.ii')],
			],
			$table = 'mtb_time'
		);
		// dd($accepted_number);

		// get booking_count
		$booking_count = $this->service->getCount(
			$keys = [
				['dtb_booking.yy', '=', Session::get('booking.yy')],
				['dtb_booking.mm', '=', Session::get('booking.mm')],
				['dtb_booking.dd', '=', Session::get('booking.dd')],
				['dtb_booking.hh', '=', Session::get('booking.hh')],
				['dtb_booking.ii', '=', Session::get('booking.ii')],
				//['dtb_booking.is_booked', '=', 1],
				['dtb_booking.is_pencil', '=', 1],
			],
			$table = 'dtb_booking'
		);
		// dd($booking_count);

		if($accepted_number > $booking_count) {

			// get vaccine
			$data['vaccine'] = $this->master->getMaster(
				$keys = [
					['mtb_vaccine_id', '=', session()->get('booking.mtb_vaccine_id')],
				],
				$table = 'vaccine'
			);
			// dd($data['vaccine']);

			// set form
			$data['form'] = [
				'url' => route('frontend.covid.booking2.subconfirm.store'),
			];

			// set title
			$data['title'] = __('lang.booking.index');

			// get lang
			$data['lang'] = $this->lang;
			// dd($data['lang']);

			// get progress
			$data['progress'] = Helper::getProgress(2);
			// dd($data['progress']);

			// dd($data);
			return view('frontend.covid.booking2.subconfirm.index', $data);
		}

		else {

			die('error');
		}
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		// get accepted_number
		$accepted_number = $this->service->getField(
			$field = 'accepted_number',
			$keys = [
				['mtb_date_id', '=', $this->service->getField(
					$field = 'mtb_date_id',
					$keys = [
						['yy', '=', Session::get('booking.yy')],
						['mm', '=', Session::get('booking.mm')],
						['dd', '=', Session::get('booking.dd')],
					],
					$table = 'mtb_date'
				)],
				['hh', '=', Session::get('booking.hh')],
				['ii', '=', Session::get('booking.ii')],
			],
			$table = 'mtb_time'
		);
		// dd($accepted_number);

		// get booking_count
		$booking_count = $this->service->getCount(
			$keys = [
				['dtb_booking.yy', '=', Session::get('booking.yy')],
				['dtb_booking.mm', '=', Session::get('booking.mm')],
				['dtb_booking.dd', '=', Session::get('booking.dd')],
				['dtb_booking.hh', '=', Session::get('booking.hh')],
				['dtb_booking.ii', '=', Session::get('booking.ii')],
				//['dtb_booking.is_booked', '=', 1],
				['dtb_booking.is_pencil', '=', 1],
			],
			$table = 'dtb_booking'
		);
		// dd($booking_count);

		// get mtb_vaccine_id
		$mtb_vaccine_id = $this->master->getDate(
			$keys = [
				['yy', '=', Session::get('booking.yy')],
				['mm', '=', Session::get('booking.mm')],
				['dd', '=', Session::get('booking.dd')],
			],
		)['mtb_vaccine_id'];
		// dd($mtb_vaccine_id);

		// booking on
		if($accepted_number > $booking_count) {
			// dd('ok');

			// set session
			$this->booking->setSession([
				'booking.mtb_vaccine_id' => $mtb_vaccine_id
			]);
			// dd(session()->all());

			// get agent
			$data['agent'] = Helper::getAgent($request);
			// dd($data['agent']);

			/**
			 * --------------------------------------------------
			 * transaction
			 * --------------------------------------------------
			 */
			DB::transaction(function() use($data) {
				// dd($data);

				$this->booking->storeSubConfirm($data);
			});

			// redirect
			return redirect()->route('frontend.covid.booking2.guest.index');
		}

		// booking off
		else {
			//die('booking off');
		}
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
