<?php

namespace App\Http\Controllers\Frontend\Covid\Frontdesk;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Frontdesk\QrRequest;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class QrController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index(int $yy = null, int $mm = null, int $dd = null)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => (is_null($dd)) ? date('j') : $dd,
		];
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = $this->master->getDate(
			$keys = [
				['mtb_date.yy', '=', $data['yy']],
				['mtb_date.mm', '=', $data['mm']],
				['mtb_date.dd', '=', $data['dd']],
			]
		);
		//echo '<pre>';print_r($data['date']);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.frontdesk.qr.show'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.frontdesk.qr.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		$result = \DB::transaction(function() use($data) {

			return $this->booking->storeBooking($data);
		});
		//echo '<pre>';print_r($result);die();

		// redirect
		return redirect()->route('frontend.covid.frontdesk.qr.complete', [
			$data['yy'],
			$data['mm'],
			$data['dd'],
		]);
	}

	/**
	 * Display the specified resource.
	 */
	public function show(QrRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// get booking
		$data['booking'] = $this->booking->getBooking(
			$keys = [
				['dtb_booking.voucher_number', '=', $data['voucher_number']],
				['dtb_booking.yy', '=', $data['yy']],
				['dtb_booking.mm', '=', $data['mm']],
				['dtb_booking.dd', '=', $data['dd']],
			]
		);
		//echo '<pre>';print_r($data['booking']);die();

		// set error
		$data['error'] = $this->error($data);
		//echo '<pre>';print_r($data['error']);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.frontdesk.qr.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.frontdesk.qr.show', $data);
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function complete(int $yy, int $mm, int $dd)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => $yy,
			'mm' => $mm,
			'dd' => $dd,
		];
		//echo '<pre>';print_r($data);die();

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.frontdesk.qr.complete', $data);
	}

	/**
	 *
	 */
	private function error($data) {

		// initialized
		$result = null;

		if(is_null($data['booking'])) {

			// not exist
			$result = 100;
		}

		else {

			// already
			if($data['booking']['is_checkedin']) $result = 200;
		}

		return $result;
	}
}
