<?php

namespace App\Http\Controllers\Frontend\Covid\Guidance;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class QaController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index($page_id = null)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'page_id' => $page_id,
		];
		//echo '<pre>';print_r($data);die();

		// set list
		$data['q05_list'] = [
			'食事も水分も摂れない',
			'呼吸が苦しい。特に歩くと酷くなる ',
			'呼吸数が1分間に25回以上、あるいは脈拍が120回/分以上',
			'熱はあるが、咳、喉の痛み、鼻水などはなく具合が悪い',
			'熱が出ると寒けがして体がブルブルとひどく震えた',
			'強いのどの症状がある',
			'頭が痛くて意識がはっきりしない',
		];

		// get fever_list
		$data['fever_list'] = [
			1 => [
				'label' => '熱',
				'keys' => [
					'37℃以下',
					'37.0〜37.9',
					'38℃以上',
				],
				'values' => [
					0,
					1,
					2,
				],
			],
			2 => [
				'label' => '鼻水・鼻づまり',
				'keys' => [
					'なし',
					'ある',
					'強い',
				],
				'values' => [
					0,
					1,
					2,
				],
			],
			3 => [
				'label' => 'のどの痛み',
				'keys' => [
					'なし',
					'ある',
					'強い',
				],
				'values' => [
					0,
					1,
					2,
				],
			],
			4 => [
				'label' => '咳',
				'keys' => [
					'なし',
					'ある',
					'強い',
				],
				'values' => [
					0,
					1,
					2,
				],
			],
			5 => [
				'label' => '寒け・体のふるえ',
				'keys' => [
					'なし',
					'寒けだけ',
					'体が震える',
					'震えが止められない',
				],
				'values' => [
					0,
					1,
					2,
					2,
				],
			],
			7 => [
				'label' => '倦怠感',
				'keys' => [
					'なし',
					'あり',
					'強い',
				],
				'values' => [
					0,
					1,
					2
				],
			],
			8 => [
				'label' => '頭痛',
				'keys' => [
					'なし',
					'ある',
					'非常に強い',
				],
				'values' => [
					0,
					1,
					1,
				],
			],
			9 => [
				'label' => '消化器症状',
				'keys' => [
					'なし',
					'嘔気・嘔吐のみ',
					'嘔気・嘔吐・下痢',
					'腹痛がある',
				],
				'values' => [
					0,
					1,
					2,
					3,
				],
			],
			10 => [
				'label' => '関節痛',
				'keys' => [
					'なし',
					'あり',
				],
				'values' => [
					0,
					1,
				],
			],
		];
		//echo '<pre>';print_r($data['step2_list']);die();

		// set title
		$data['title'] = __("lang.booking.index");

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.guidance.qa.page', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}

	/**
	 * Display a listing of the resource.
	 */
	public function test()
	{
		Session::flush();
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// set title
		$data['title'] = __("lang.booking.test");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.booking.home.test', $data);
	}
}
