<?php

namespace App\Http\Controllers\Frontend\Covid\Mobile;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Frontend\Covid\Frontdesk\QrRequest;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class StatusController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index(int $yy = null, int $mm = null, int $dd = null, int $hh = null)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'dd' => (is_null($dd)) ? date('j') : $dd,
			'hh' => (is_null($hh)) ? (int)date('H') : $hh,
		];
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = $this->master->getDate(
			$keys = [
				['mtb_date.yy', '=', $data['yy']],
				['mtb_date.mm', '=', $data['mm']],
				['mtb_date.dd', '=', $data['dd']],
			]
		);
		//echo '<pre>';print_r($data['date']);die();

        // get link
		$data['link'] = [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], $data['dd'])->subDay(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], $data['dd'])->addDay(1)->toDateString()),
		];
		//echo '<pre>';print_r($data['link']);die();

		if(!is_null($data['date'])) {

			// get time_list
			$data['time_list'] = Helper::getTimeDropdownList($this->master->getTimeDropdownList(
				$keys = [
					['mtb_time.mtb_date_id', '=', $data['date']['mtb_date_id']],
				],
				$orders = [
					'mtb_time.hh' => 'ASC',
					'mtb_time.ii' => 'ASC',
				],
				$options = []
			));
			//echo '<pre>';print_r($data['time_list']);die();

			// set keys
			$keys = [
				['yy', '=', $data['yy']],
				['mm', '=', $data['mm']],
				['dd', '=', $data['dd']],
				['is_booked', '=', 1],
			];
			//echo '<pre>';print_r($keys);die();

			// set options
			$options['groupby'] = [
				'yy',
				'mm',
				'dd',
			];
			//echo '<pre>';print_r($options['groupby']);die();

			// get booking_status_count_list
			$data['booking_status_count_list'][0] = $this->booking->getBookingStatusCountList(
				$keys,
				$orders = [],
				$options
			);
			//echo '<pre>';print_r($data['booking_status_count_list']);die();

			if(!is_null($data['hh'])) {

				$keys = array_merge($keys, [
					['hh', '=', $data['hh']],
				]);
				//echo '<pre>';print_r($keys);die();

				$options['groupby'] = array_merge($options['groupby'], [
					'hh',
				]);
				//echo '<pre>';print_r($options['groupby']);die();

				// get booking_status_count_list
				$data['booking_status_count_list'][$data['hh']] = $this->booking->getBookingStatusCountList(
					$keys,
					$orders = [],
					$options
				);
				//echo '<pre>';print_r($data['booking_status_count_list']);die();
			}
		}

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.mobile.status.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		$result = \DB::transaction(function() use($data) {

			return $this->booking->storeBooking($data);
		});
		//echo '<pre>';print_r($result);die();

		// redirect
		return redirect()->route('frontend.covid.frontdesk.qr.complete', [
			$data['yy'],
			$data['mm'],
			$data['dd'],
		]);
	}

	/**
	 * Display the specified resource.
	 */
	public function show(QrRequest $request)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		// get booking
		$data['booking'] = $this->booking->getBooking(
			$keys = [
				['dtb_booking.voucher_number', '=', $data['voucher_number']],
				['dtb_booking.yy', '=', $data['yy']],
				['dtb_booking.mm', '=', $data['mm']],
				['dtb_booking.dd', '=', $data['dd']],
			]
		);
		//echo '<pre>';print_r($data['booking']);die();

		// set error
		$data['error'] = $this->error($data);
		//echo '<pre>';print_r($data['error']);die();

		// set form
		$data['form'] = [
			'url' => route('frontend.covid.frontdesk.qr.store'),
		];

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.frontdesk.qr.show', $data);
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function complete(int $yy, int $mm, int $dd)
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => $yy,
			'mm' => $mm,
			'dd' => $dd,
		];
		//echo '<pre>';print_r($data);die();

		// set title
		$data['title'] = __("lang.booking.index");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('frontend.covid.frontdesk.qr.complete', $data);
	}

	/**
	 *
	 */
	private function error($data) {

		// initialized
		$result = null;

		if(is_null($data['booking'])) {

			// not exist
			$result = 100;
		}

		else {

			// already
			if($data['booking']['is_checkedin']) $result = 200;
		}

		return $result;
	}
}
