<?php

namespace App\Http\Middleware\Covid;

use Closure;
use Session;

class Mypage
{
    /**
     * Run the request filter.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $session = $request->session()->get('booking.voucher_number');

        if (!isset($session)) {

            return redirect()->route('frontend.covid.booking.mypage.signin.index')
                ->withErrors([
                    "本人認証できませんでした。",
                    "接種券番号または生年月日が異なる可能性があります。",
                    "もしくは予約が登録されておりません。"
                ]);
            //return redirect()->action('Frontend\Covid\Booking\Mypage\SigninController@index');
        }

        return $next($request);
    }
}
