<?php

namespace App\Http\Requests\Backend;

use Illuminate\Foundation\Http\FormRequest;

class BookingRequest extends FormRequest
{
	protected $table = 'dtb_booking';

	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		// get data
		$data = $this->all();
		//echo '<pre>';print_r($data);die();

		$return = [
			'booking.yy' => 'required',
			'booking.mm' => 'required',
			'booking.dd' => 'required',
			'date_last.yy' => 'required',
			'date_last.mm' => 'required',
			'date_last.dd' => 'required',
			'booking.patient_skana' => 'required',
			'booking.patient_gkana' => 'required',
			'birthday.yy' => 'required',
			'birthday.mm' => 'required',
			'birthday.dd' => 'required',
		];

		// processing for create
		if(is_null($data['booking']['booking_code'])) {

			// $return = array_merge($return, [
			// 	'booking.voucher_number' => "required|unique:{$this->table},voucher_number",
			// ]);
		}

		// processing for update
		else {

			$return = array_merge($return, [
				'booking.voucher_number' => "required",
			]);
		}

		return $return;
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		// get data
		$data = $this->all();
		//echo '<pre>';print_r($data);die();

		$return = [
			'booking.yy.required' => __("lang.validation.booking.yy"),
			'booking.mm.required' => __("lang.validation.booking.mm"),
			'booking.dd.required' => __("lang.validation.booking.dd"),
			'date_last.yy.required' => __("lang.validation.date_last.yy"),
			'date_last.mm.required' => __("lang.validation.date_last.mm"),
			'date_last.dd.required' => __("lang.validation.date_last.dd"),
			'booking.patient_skana.required' => __("lang.validation.booking.patient_skana"),
			'booking.patient_gkana.required' => __("lang.validation.booking.patient_gkana"),
			'birthday.yy.required' => __("lang.validation.birthday.yy"),
			'birthday.mm.required' => __("lang.validation.birthday.mm"),
			'birthday.dd.required' => __("lang.validation.birthday.dd"),
			'booking.voucher_number.required' => __("lang.validation.booking.voucher_number"),
		];

		// processing for create
		if(is_null($data['booking']['booking_code'])) {
			//die('create');

			$return = array_merge($return, [
				'booking.voucher_number.unique' => __("lang.validation.booking.voucher_number_unique"),
			]);
		}

		// processing for update
		else {

			// nothing to do
		}

		return $return;
	}
}
