<?php

namespace App\Http\Requests\Backend\Covid\Booking2;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StatusRequest extends FormRequest
{
	protected $table = 'dtb_booking';

	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		// get data
		$data = $this->all();
		//echo '<pre>';print_r($data);die();

		$return = [
			'booking.yy' => 'required',
			'booking.mm' => 'required',
			'booking.dd' => 'required',
			'booking.patient_skana' => 'required',
			'booking.patient_gkana' => 'required',
			'booking.address1' => 'required',
			'booking.address2' => 'required',
			'booking.address3' => 'required',
			'birthday.yy' => 'required',
			'birthday.mm' => 'required',
			'birthday.dd' => 'required',
			'birthday.dd' => 'required',
		];

		// // processing for create
		// if(is_null($data['booking']['booking_code'])) {

		// 	$return = array_merge($return, [
		// 		//'booking.voucher_number' => "required|unique:{$this->table},voucher_number",
				
		// 		// updated at 2023.09.28
		// 		'booking.voucher_number' => [
		// 			'required',
		// 			"required:{$this->table},voucher_number",
		// 			Rule::unique($this->table, 'voucher_number')->where('shots_number', $data['booking']['shots_number']),
		// 		],
		// 	]);
		// 	//echo '<pre>';print_r($return);die();
		// }

		// // processing for update
		// else {

		// 	$return = array_merge($return, [
		// 		'booking.voucher_number' => "required",
		// 	]);
		// }

		return $return;
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		// get data
		$data = $this->all();
		//echo '<pre>';print_r($data);die();

		$return = [
			'booking.yy.required' => __("lang.validation.booking.yy"),
			'booking.mm.required' => __("lang.validation.booking.mm"),
			'booking.dd.required' => __("lang.validation.booking.dd"),
			'booking.patient_skana.required' => __("lang.validation.booking.patient_skana"),
			'booking.patient_gkana.required' => __("lang.validation.booking.patient_gkana"),
			'booking.address1.required' => __("lang.validation.booking.address1"),
			'booking.address2.required' => __("lang.validation.booking.address2"),
			'booking.address3.required' => __("lang.validation.booking.address3"),
			'birthday.yy.required' => __("lang.validation.birthday.yy"),
			'birthday.mm.required' => __("lang.validation.birthday.mm"),
			'birthday.dd.required' => __("lang.validation.birthday.dd"),
		];

		// // processing for create
		// if(is_null($data['booking']['booking_code'])) {
		// 	//die('create');

		// 	$return = array_merge($return, [
		// 		'booking.voucher_number.unique' => __("lang.validation.booking.voucher_number_unique"),
		// 	]);
		// }

		// // processing for update
		// else {

		// 	// nothing to do
		// }

		return $return;
	}
}
