<?php

namespace App\Http\Requests\Backend\Covid\Frontdesk;

use Illuminate\Foundation\Http\FormRequest;

class QrRequest extends FormRequest
{
	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		return [
			'booking.qr_number' => 'required',
		];
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		return [
			'booking.qr_number.required' => __("lang.validation.frontdesk.voucher_number"),
		];
	}
}
