<?php

namespace App\Http\Requests\Frontend\Covid\Booking;

use Illuminate\Foundation\Http\FormRequest;

class ConditionRequest extends FormRequest
{
	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		return [
			'date_last.yy' => 'required',
			'date_last.mm' => 'required',
			'date_last.dd' => 'required',
		];
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		return [
			'date_last.yy.required' => __("lang.validation.date_last.dd"),
			'date_last.mm.required' => __("lang.validation.date_last.mm"),
			'date_last.dd.required' => __("lang.validation.date_last.dd"),
		];
	}
}
