<?php

namespace App\Http\Requests\Frontend\Covid\Booking;

use Illuminate\Foundation\Http\FormRequest;

class DatetimeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'booking.yy' => 'required',
            'booking.mm' => 'required',
            'booking.dd' => 'required',
            'booking.hh' => 'required',
            //'booking.ii' => 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'booking.yy.required' => __("lang.validation.booking.yy"),
            'booking.mm.required' => __("lang.validation.booking.mm"),
            'booking.dd.required' => __("lang.validation.booking.dd"),
            'booking.hh.required' => __("lang.validation.booking.hh"),
            //'booking.ii.required' => __("lang.validation.booking.ii"),
        ];
    }
}
