<?php

namespace App\Http\Requests\Frontend\Covid\Booking;

use Illuminate\Foundation\Http\FormRequest;

class DiseaseRequest extends FormRequest
{
	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		return [
			'booking.is_disease' => 'required',
		];
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		return [
			'booking.is_disease.required' => __("lang.validation.booking.is_disease"),
		];
	}
}
