<?php

namespace App\Http\Requests\Frontend\Covid\Booking;

use Illuminate\Foundation\Http\FormRequest;

class GuestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'booking.patient_skana' => 'required',
            'booking.patient_gkana' => 'required',
            'booking.mobile' => 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'booking.patient_skana.required' => __("lang.validation.booking.patient_skana"),
            'booking.patient_gkana.required' => __("lang.validation.booking.patient_gkana"),
            'booking.mobile.required' => __("lang.validation.booking.mobile"),
        ];
    }
}
