<?php

namespace App\Http\Requests\Frontend\Covid\Booking\Mypage;

use Illuminate\Foundation\Http\FormRequest;

class SigninRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'booking.voucher_number' => 'required|numeric|digits:10',
            'birthday.yy' => 'required',
            'birthday.mm' => 'required',
            'birthday.dd' => 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'booking.voucher_number.required' => __("lang.validation.booking.voucher_number"),
            'birthday.yy.required' => __("lang.validation.birthday.dd"),
            'birthday.mm.required' => __("lang.validation.birthday.mm"),
            'birthday.dd.required' => __("lang.validation.birthday.dd"),
        ];
    }
}