<?php

namespace App\Http\Requests\Frontend\Covid\Booking;

use Illuminate\Foundation\Http\FormRequest;

class PersonalRequest extends FormRequest
{
	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		return [
			'birthday.yy' => 'required',
			'birthday.mm' => 'required',
			'birthday.dd' => 'required',
			//'booking.is_staff' => 'required',
		];
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		return [
			'birthday.yy.required' => __("lang.validation.birthday.dd"),
			'birthday.mm.required' => __("lang.validation.birthday.mm"),
			'birthday.dd.required' => __("lang.validation.birthday.dd"),
			//'booking.is_staff.required' => __("lang.validation.booking.is_staff"),
		];
	}
}
