<?php

namespace App\Http\Requests\Frontend\Covid\Booking;

use Illuminate\Foundation\Http\FormRequest;

class QrRequest extends FormRequest
{
    protected $table = 'dtb_booking';

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'booking.voucher_number' => "required|unique:{$this->table},voucher_number",
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'booking.voucher_number.required' => __("lang.validation.booking.voucher_number"),
            'booking.voucher_number.unique' => __("lang.validation.booking.voucher_number_unique"),
        ];
    }
}
