<?php

namespace App\Http\Requests\Frontend\Covid\Booking2;

use Illuminate\Foundation\Http\FormRequest;

class GuestRequest extends FormRequest
{
	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		return [
			'booking.patient_sname' => 'required',
			'booking.patient_gname' => 'required',
			'booking.patient_skana' => 'required',
			'booking.patient_gkana' => 'required',
			'booking.mobile' => 'required',
			'booking.zip' => 'required',
			'booking.address1' => 'required',
			'booking.address2' => 'required',
			'booking.address3' => 'required',
		];
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		return [
			'booking.patient_sname.required' => __('lang.validation.booking.patient_sname'),
			'booking.patient_gname.required' => __('lang.validation.booking.patient_gname'),
			'booking.patient_skana.required' => __('lang.validation.booking.patient_skana'),
			'booking.patient_gkana.required' => __('lang.validation.booking.patient_gkana'),
			'booking.mobile.required' => __('lang.validation.booking.mobile'),
			'booking.zip.required' => __('lang.validation.booking.zip'),
			'booking.address1.required' => __('lang.validation.booking.address1'),
			'booking.address2.required' => __('lang.validation.booking.address2'),
			'booking.address3.required' => __('lang.validation.booking.address3'),
		];
	}
}
