<?php

namespace App\Http\Requests\Frontend\Covid\Booking2;

use Illuminate\Foundation\Http\FormRequest;

class VaccineFormRequest extends FormRequest
{
	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		$return = [];

		for ($i = 1; $i <= 16; $i++) {

			if ($i != 6) {

				$return = array_merge($return, [
					"form.{$i}.value" => 'required',
				]);
			}
		}
		// dd($return);
		
		return $return;
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		$return = [];

		for ($i = 1; $i <= 16; $i++) {

			if ($i != 6) {

				$return = array_merge($return, [
					"form.{$i}.value.required" => "質問{$i}は回答必須項目です",
				]);
			}
		}
		// dd($return);

		return $return;
	}
}
