<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
	/**
	 * Register any application services.
	 */
	public function register(): void
	{
		foreach([

			// Service
			[
				\App\Services\ServiceInterface::class,
				\App\Services\Service::class
			],

			// Master
			[
				\App\Services\MasterInterface::class,
				\App\Services\Master::class
			],

			// Booking
			[
				\App\Services\BookingInterface::class,
				\App\Services\Booking::class
			],

			// File
			[
				\App\Services\FileInterface::class,
				\App\Services\File::class
			],

			// Maintenance
			[
				\App\Services\MaintenanceInterface::class,
				\App\Services\Maintenance::class
			],

			// Math
			[
				\App\Services\MathInterface::class,
				\App\Services\Math::class
			],

			// Staff
			[
				\App\Services\StaffInterface::class,
				\App\Services\Staff::class
			],
		] as $register) {

			$this->app->singleton(
				$register[0],
				$register[1]
			);
		}
	}

	/**
	 * Bootstrap any application services.
	 */
	public function boot(): void
	{
		//
	}
}
